/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.instance;

import io.zeebe.db.DbValue;
import io.zeebe.db.impl.ZeebeDbConstants;
import io.zeebe.engine.processor.workflow.WorkflowInstanceLifecycle;
import io.zeebe.engine.state.instance.IndexedRecord;
import io.zeebe.protocol.impl.record.value.workflowinstance.WorkflowInstanceRecord;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import io.zeebe.util.buffer.BufferReader;
import io.zeebe.util.buffer.BufferUtil;
import io.zeebe.util.buffer.BufferWriter;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class ElementInstance
implements DbValue {
    private final IndexedRecord elementRecord;
    private long parentKey = -1L;
    private int childCount;
    private long jobKey;
    private int activeTokens = 0;

    ElementInstance() {
        this.elementRecord = new IndexedRecord();
    }

    public ElementInstance(long key, ElementInstance parent, WorkflowInstanceIntent state, WorkflowInstanceRecord value) {
        this.elementRecord = new IndexedRecord(key, state, value);
        this.parentKey = parent.getKey();
        ++parent.childCount;
    }

    public ElementInstance(long key, WorkflowInstanceIntent state, WorkflowInstanceRecord value) {
        this.elementRecord = new IndexedRecord(key, state, value);
    }

    public long getKey() {
        return this.elementRecord.getKey();
    }

    public WorkflowInstanceIntent getState() {
        return this.elementRecord.getState();
    }

    public void setState(WorkflowInstanceIntent state) {
        this.elementRecord.setState(state);
    }

    public WorkflowInstanceRecord getValue() {
        return this.elementRecord.getValue();
    }

    public void setValue(WorkflowInstanceRecord value) {
        this.elementRecord.setValue(value);
    }

    public long getJobKey() {
        return this.jobKey;
    }

    public void setJobKey(long jobKey) {
        this.jobKey = jobKey;
    }

    public void decrementChildCount() {
        --this.childCount;
    }

    public boolean canTerminate() {
        return WorkflowInstanceLifecycle.canTerminate(this.getState());
    }

    public boolean isActive() {
        return WorkflowInstanceLifecycle.isActive(this.getState());
    }

    public boolean isTerminating() {
        return WorkflowInstanceLifecycle.isTerminating(this.getState());
    }

    public void spawnToken() {
        ++this.activeTokens;
    }

    public void consumeToken() {
        --this.activeTokens;
    }

    public int getNumberOfActiveTokens() {
        return this.activeTokens;
    }

    public int getNumberOfActiveElementInstances() {
        return this.childCount;
    }

    public int getNumberOfActiveExecutionPaths() {
        return this.activeTokens + this.getNumberOfActiveElementInstances();
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        int startOffset = offset;
        this.childCount = buffer.getInt(offset, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        this.jobKey = buffer.getLong(offset += 4, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        this.activeTokens = buffer.getInt(offset += 8, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        this.parentKey = buffer.getLong(offset += 4, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        offset += 8;
        offset = BufferUtil.readIntoBuffer((DirectBuffer)buffer, (int)offset, (BufferReader)this.elementRecord);
        assert (offset - startOffset == length) : "End offset differs from length";
    }

    public int getLength() {
        return 28 + this.elementRecord.getLength();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        int startOffset = offset;
        buffer.putInt(offset, this.childCount, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        buffer.putLong(offset += 4, this.jobKey, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        buffer.putInt(offset += 8, this.activeTokens, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        buffer.putLong(offset += 4, this.parentKey, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        offset += 8;
        offset = BufferUtil.writeIntoBuffer((MutableDirectBuffer)buffer, (int)offset, (BufferWriter)this.elementRecord);
        assert (offset - startOffset == this.getLength()) : "End offset differs from getLength()";
    }

    public long getParentKey() {
        return this.parentKey;
    }

    public String toString() {
        return "ElementInstance{elementRecord=" + this.elementRecord + ", parentKey=" + this.parentKey + ", childCount=" + this.childCount + ", jobKey=" + this.jobKey + ", activeTokens=" + this.activeTokens + '}';
    }
}

