/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.instance;

import io.zeebe.db.DbValue;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.msgpack.property.ArrayProperty;
import io.zeebe.msgpack.property.BaseProperty;
import io.zeebe.msgpack.property.BooleanProperty;
import io.zeebe.msgpack.value.BaseValue;
import io.zeebe.msgpack.value.StringValue;
import java.util.Objects;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class EventScopeInstance
extends UnpackedObject
implements DbValue {
    private final BooleanProperty acceptingProp = new BooleanProperty("accepting");
    private final ArrayProperty<StringValue> interruptingProp = new ArrayProperty("interrupting", (BaseValue)new StringValue());

    public EventScopeInstance() {
        this.declareProperty((BaseProperty)this.acceptingProp).declareProperty(this.interruptingProp);
    }

    public EventScopeInstance(EventScopeInstance other) {
        this();
        int length = other.getLength();
        UnsafeBuffer buffer = new UnsafeBuffer(new byte[length]);
        other.write((MutableDirectBuffer)buffer, 0);
        this.wrap((DirectBuffer)buffer, 0, length);
    }

    public EventScopeInstance setAccepting(boolean accepting) {
        this.acceptingProp.setValue(accepting);
        return this;
    }

    public boolean isAccepting() {
        return this.acceptingProp.getValue();
    }

    public EventScopeInstance addInterrupting(DirectBuffer elementId) {
        ((StringValue)this.interruptingProp.add()).wrap(elementId);
        return this;
    }

    public boolean isInterrupting(DirectBuffer elementId) {
        for (StringValue stringValue : this.interruptingProp) {
            if (!stringValue.getValue().equals(elementId)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EventScopeInstance)) {
            return false;
        }
        EventScopeInstance that = (EventScopeInstance)((Object)o);
        return Objects.equals(this.acceptingProp, that.acceptingProp) && Objects.equals(this.interruptingProp, that.interruptingProp);
    }

    public int hashCode() {
        return Objects.hash(this.acceptingProp, this.interruptingProp);
    }
}

