/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.instance;

import io.zeebe.db.ColumnFamily;
import io.zeebe.db.DbContext;
import io.zeebe.db.DbKey;
import io.zeebe.db.DbValue;
import io.zeebe.db.ZeebeDb;
import io.zeebe.db.impl.DbCompositeKey;
import io.zeebe.db.impl.DbLong;
import io.zeebe.engine.state.ZbColumnFamilies;
import io.zeebe.engine.state.instance.EventScopeInstance;
import io.zeebe.engine.state.instance.EventTrigger;
import java.util.Collection;
import org.agrona.DirectBuffer;

public class EventScopeInstanceState {
    private final DbLong eventScopeKey = new DbLong();
    private final EventScopeInstance eventScopeInstance = new EventScopeInstance();
    private final ColumnFamily<DbLong, EventScopeInstance> eventScopeInstanceColumnFamily;
    private final DbLong eventTriggerScopeKey;
    private final DbLong eventTriggerEventKey;
    private final DbCompositeKey<DbLong, DbLong> eventTriggerKey;
    private final EventTrigger eventTrigger;
    private final ColumnFamily<DbCompositeKey<DbLong, DbLong>, EventTrigger> eventTriggerColumnFamily;

    public EventScopeInstanceState(ZeebeDb<ZbColumnFamilies> zeebeDb, DbContext dbContext) {
        this.eventScopeInstanceColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.EVENT_SCOPE, dbContext, (DbKey)this.eventScopeKey, (DbValue)this.eventScopeInstance);
        this.eventTriggerScopeKey = new DbLong();
        this.eventTriggerEventKey = new DbLong();
        this.eventTriggerKey = new DbCompositeKey((DbKey)this.eventTriggerScopeKey, (DbKey)this.eventTriggerEventKey);
        this.eventTrigger = new EventTrigger();
        this.eventTriggerColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.EVENT_TRIGGER, dbContext, this.eventTriggerKey, (DbValue)this.eventTrigger);
    }

    public void shutdownInstance(long eventScopeKey) {
        EventScopeInstance instance = this.getInstance(eventScopeKey);
        if (instance != null) {
            this.eventScopeKey.wrapLong(eventScopeKey);
            instance.setAccepting(false);
            this.eventScopeInstanceColumnFamily.put((DbKey)this.eventScopeKey, (DbValue)instance);
        }
    }

    public boolean createIfNotExists(long eventScopeKey, Collection<DirectBuffer> interruptingIds) {
        this.eventScopeKey.wrapLong(eventScopeKey);
        boolean wasCreated = false;
        if (!this.eventScopeInstanceColumnFamily.exists((DbKey)this.eventScopeKey)) {
            this.createInstance(eventScopeKey, interruptingIds);
            wasCreated = true;
        }
        return wasCreated;
    }

    public void createInstance(long eventScopeKey, Collection<DirectBuffer> interruptingIds) {
        this.eventScopeInstance.reset();
        this.eventScopeKey.wrapLong(eventScopeKey);
        this.eventScopeInstance.setAccepting(true);
        for (DirectBuffer interruptingId : interruptingIds) {
            this.eventScopeInstance.addInterrupting(interruptingId);
        }
        this.eventScopeInstanceColumnFamily.put((DbKey)this.eventScopeKey, (DbValue)this.eventScopeInstance);
    }

    public EventScopeInstance getInstance(long eventScopeKey) {
        this.eventScopeKey.wrapLong(eventScopeKey);
        EventScopeInstance instance = (EventScopeInstance)this.eventScopeInstanceColumnFamily.get((DbKey)this.eventScopeKey);
        return instance != null ? new EventScopeInstance(instance) : null;
    }

    public void deleteInstance(long eventScopeKey) {
        this.eventTriggerScopeKey.wrapLong(eventScopeKey);
        this.eventTriggerColumnFamily.whileEqualPrefix((DbKey)this.eventTriggerScopeKey, (key, value) -> this.deleteTrigger((DbCompositeKey<DbLong, DbLong>)key));
        this.eventScopeKey.wrapLong(eventScopeKey);
        this.eventScopeInstanceColumnFamily.delete((DbKey)this.eventScopeKey);
    }

    public boolean triggerEvent(long eventScopeKey, long eventKey, DirectBuffer elementId, DirectBuffer variables) {
        this.eventScopeKey.wrapLong(eventScopeKey);
        EventScopeInstance instance = (EventScopeInstance)this.eventScopeInstanceColumnFamily.get((DbKey)this.eventScopeKey);
        if (instance != null && instance.isAccepting()) {
            if (instance.isInterrupting(elementId)) {
                instance.setAccepting(false);
                this.eventScopeInstanceColumnFamily.put((DbKey)this.eventScopeKey, (DbValue)instance);
            }
            this.createTrigger(eventScopeKey, eventKey, elementId, variables);
            return true;
        }
        return false;
    }

    private void createTrigger(long eventScopeKey, long eventKey, DirectBuffer elementId, DirectBuffer variables) {
        this.eventTriggerScopeKey.wrapLong(eventScopeKey);
        this.eventTriggerEventKey.wrapLong(eventKey);
        this.eventTrigger.setElementId(elementId).setVariables(variables).setEventKey(eventKey);
        this.eventTriggerColumnFamily.put(this.eventTriggerKey, (DbValue)this.eventTrigger);
    }

    public EventTrigger peekEventTrigger(long eventScopeKey) {
        this.eventTriggerScopeKey.wrapLong(eventScopeKey);
        EventTrigger[] next = new EventTrigger[1];
        this.eventTriggerColumnFamily.whileEqualPrefix((DbKey)this.eventTriggerScopeKey, (key, value) -> {
            next[0] = new EventTrigger((EventTrigger)value);
            return false;
        });
        return next[0];
    }

    public EventTrigger pollEventTrigger(long eventScopeKey) {
        this.eventTriggerScopeKey.wrapLong(eventScopeKey);
        EventTrigger[] next = new EventTrigger[1];
        this.eventTriggerColumnFamily.whileEqualPrefix((DbKey)this.eventTriggerScopeKey, (key, value) -> {
            next[0] = new EventTrigger((EventTrigger)value);
            this.eventTriggerColumnFamily.delete(key);
            return false;
        });
        return next[0];
    }

    public void deleteTrigger(long eventScopeKey, long eventKey) {
        this.eventTriggerScopeKey.wrapLong(eventScopeKey);
        this.eventTriggerEventKey.wrapLong(eventKey);
        this.deleteTrigger(this.eventTriggerKey);
    }

    private void deleteTrigger(DbCompositeKey<DbLong, DbLong> triggerKey) {
        this.eventTriggerColumnFamily.delete(triggerKey);
    }
}

