/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.instance;

import io.zeebe.db.ColumnFamily;
import io.zeebe.db.DbContext;
import io.zeebe.db.DbKey;
import io.zeebe.db.DbValue;
import io.zeebe.db.ZeebeDb;
import io.zeebe.db.impl.DbLong;
import io.zeebe.engine.state.ZbColumnFamilies;
import io.zeebe.engine.state.instance.UnpackedObjectValue;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import java.util.function.ObjLongConsumer;

public class IncidentState {
    public static final int MISSING_INCIDENT = -1;
    private final DbLong incidentKey = new DbLong();
    private final UnpackedObjectValue incidenRecordToRead = new UnpackedObjectValue();
    private final UnpackedObjectValue incidentRecordToWrite;
    private final ColumnFamily<DbLong, UnpackedObjectValue> incidentColumnFamily;
    private final DbLong elementInstanceKey;
    private final ColumnFamily<DbLong, DbLong> workflowInstanceIncidentColumnFamily;
    private final DbLong jobKey;
    private final ColumnFamily<DbLong, DbLong> jobIncidentColumnFamily;

    public IncidentState(ZeebeDb<ZbColumnFamilies> zeebeDb, DbContext dbContext) {
        this.incidenRecordToRead.wrapObject((UnpackedObject)new IncidentRecord());
        this.incidentRecordToWrite = new UnpackedObjectValue();
        this.incidentColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.INCIDENTS, dbContext, (DbKey)this.incidentKey, (DbValue)this.incidenRecordToRead);
        this.elementInstanceKey = new DbLong();
        this.workflowInstanceIncidentColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.INCIDENT_WORKFLOW_INSTANCES, dbContext, (DbKey)this.elementInstanceKey, (DbValue)this.incidentKey);
        this.jobKey = new DbLong();
        this.jobIncidentColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.INCIDENT_JOBS, dbContext, (DbKey)this.jobKey, (DbValue)this.incidentKey);
    }

    public void createIncident(long incidentKey, IncidentRecord incident) {
        this.incidentKey.wrapLong(incidentKey);
        this.incidentRecordToWrite.wrapObject((UnpackedObject)incident);
        this.incidentColumnFamily.put((DbKey)this.incidentKey, (DbValue)this.incidentRecordToWrite);
        if (this.isJobIncident(incident)) {
            this.jobKey.wrapLong(incident.getJobKey());
            this.jobIncidentColumnFamily.put((DbKey)this.jobKey, (DbValue)this.incidentKey);
        } else {
            this.elementInstanceKey.wrapLong(incident.getElementInstanceKey());
            this.workflowInstanceIncidentColumnFamily.put((DbKey)this.elementInstanceKey, (DbValue)this.incidentKey);
        }
    }

    public IncidentRecord getIncidentRecord(long incidentKey) {
        this.incidentKey.wrapLong(incidentKey);
        UnpackedObjectValue unpackedObjectValue = (UnpackedObjectValue)this.incidentColumnFamily.get((DbKey)this.incidentKey);
        if (unpackedObjectValue != null) {
            return (IncidentRecord)unpackedObjectValue.getObject();
        }
        return null;
    }

    public void deleteIncident(long key) {
        IncidentRecord incidentRecord = this.getIncidentRecord(key);
        if (incidentRecord != null) {
            this.incidentColumnFamily.delete((DbKey)this.incidentKey);
            if (this.isJobIncident(incidentRecord)) {
                this.jobKey.wrapLong(incidentRecord.getJobKey());
                this.jobIncidentColumnFamily.delete((DbKey)this.jobKey);
            } else {
                this.elementInstanceKey.wrapLong(incidentRecord.getElementInstanceKey());
                this.workflowInstanceIncidentColumnFamily.delete((DbKey)this.elementInstanceKey);
            }
        }
    }

    public long getWorkflowInstanceIncidentKey(long workflowInstanceKey) {
        this.elementInstanceKey.wrapLong(workflowInstanceKey);
        DbLong incidentKey = (DbLong)this.workflowInstanceIncidentColumnFamily.get((DbKey)this.elementInstanceKey);
        if (incidentKey != null) {
            return incidentKey.getValue();
        }
        return -1L;
    }

    public long getJobIncidentKey(long jobKey) {
        this.jobKey.wrapLong(jobKey);
        DbLong incidentKey = (DbLong)this.jobIncidentColumnFamily.get((DbKey)this.jobKey);
        if (incidentKey != null) {
            return incidentKey.getValue();
        }
        return -1L;
    }

    public boolean isJobIncident(IncidentRecord record) {
        return record.getJobKey() > 0L;
    }

    public void forExistingWorkflowIncident(long elementInstanceKey, ObjLongConsumer<IncidentRecord> resolver) {
        boolean hasIncident;
        long workflowIncidentKey = this.getWorkflowInstanceIncidentKey(elementInstanceKey);
        boolean bl = hasIncident = workflowIncidentKey != -1L;
        if (hasIncident) {
            IncidentRecord incidentRecord = this.getIncidentRecord(workflowIncidentKey);
            resolver.accept(incidentRecord, workflowIncidentKey);
        }
    }
}

