/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.instance;

import io.zeebe.db.DbValue;
import io.zeebe.db.impl.ZeebeDbConstants;
import io.zeebe.protocol.impl.record.value.workflowinstance.WorkflowInstanceRecord;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import io.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class IndexedRecord
implements DbValue {
    private long key;
    private WorkflowInstanceIntent state;
    private final WorkflowInstanceRecord value = new WorkflowInstanceRecord();

    IndexedRecord() {
    }

    public IndexedRecord(long key, WorkflowInstanceIntent instanceState, WorkflowInstanceRecord record) {
        this.key = key;
        this.state = instanceState;
        this.setValue(record);
    }

    public long getKey() {
        return this.key;
    }

    public WorkflowInstanceIntent getState() {
        return this.state;
    }

    public void setState(WorkflowInstanceIntent state) {
        this.state = state;
    }

    public WorkflowInstanceRecord getValue() {
        return this.value;
    }

    public void setValue(WorkflowInstanceRecord value) {
        UnsafeBuffer valueBuffer = new UnsafeBuffer(0L, 0);
        int encodedLength = value.getLength();
        valueBuffer.wrap(new byte[encodedLength]);
        value.write((MutableDirectBuffer)valueBuffer, 0);
        this.value.wrap((DirectBuffer)valueBuffer, 0, encodedLength);
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        int startOffset = offset;
        this.key = buffer.getLong(offset, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        short stateIdx = buffer.getShort(offset += 8, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        this.state = WorkflowInstanceIntent.values()[stateIdx];
        int currentLength = (offset += 2) - startOffset;
        DirectBuffer clonedBuffer = BufferUtil.cloneBuffer((DirectBuffer)buffer, (int)offset, (int)(length - currentLength));
        this.value.wrap(clonedBuffer);
    }

    public int getLength() {
        return 10 + this.value.getLength();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        int startOffset = offset;
        buffer.putLong(offset, this.key, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        buffer.putShort(offset += 8, this.state.value(), ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        assert ((offset += 2) - startOffset == this.getLength() - this.value.getLength()) : "End offset differs with getLength()";
        this.value.write(buffer, offset);
    }

    public String toString() {
        return "IndexedRecord{key=" + this.key + ", state=" + this.state + ", value=" + this.value + '}';
    }
}

