/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.instance;

import io.zeebe.db.ColumnFamily;
import io.zeebe.db.DbContext;
import io.zeebe.db.DbKey;
import io.zeebe.db.DbValue;
import io.zeebe.db.ZeebeDb;
import io.zeebe.db.impl.DbByte;
import io.zeebe.db.impl.DbCompositeKey;
import io.zeebe.db.impl.DbLong;
import io.zeebe.db.impl.DbNil;
import io.zeebe.db.impl.DbString;
import io.zeebe.engine.state.ZbColumnFamilies;
import io.zeebe.engine.state.instance.UnpackedObjectValue;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.value.job.JobRecord;
import io.zeebe.util.EnsureUtil;
import java.util.function.BiFunction;
import org.agrona.DirectBuffer;

public class JobState {
    private final UnpackedObjectValue jobRecordToRead = new UnpackedObjectValue();
    private final UnpackedObjectValue jobRecordToWrite;
    private final DbLong jobKey;
    private final ColumnFamily<DbLong, UnpackedObjectValue> jobsColumnFamily;
    private final DbByte jobState;
    private final ColumnFamily<DbLong, DbByte> statesJobColumnFamily;
    private final DbString jobTypeKey;
    private final DbCompositeKey<DbString, DbLong> typeJobKey;
    private final ColumnFamily<DbCompositeKey<DbString, DbLong>, DbNil> activatableColumnFamily;
    private final DbLong deadlineKey;
    private final DbCompositeKey<DbLong, DbLong> deadlineJobKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbLong>, DbNil> deadlinesColumnFamily;

    public JobState(ZeebeDb<ZbColumnFamilies> zeebeDb, DbContext dbContext) {
        this.jobRecordToRead.wrapObject((UnpackedObject)new JobRecord());
        this.jobRecordToWrite = new UnpackedObjectValue();
        this.jobKey = new DbLong();
        this.jobsColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.JOBS, dbContext, (DbKey)this.jobKey, (DbValue)this.jobRecordToRead);
        this.jobState = new DbByte();
        this.statesJobColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.JOB_STATES, dbContext, (DbKey)this.jobKey, (DbValue)this.jobState);
        this.jobTypeKey = new DbString();
        this.typeJobKey = new DbCompositeKey((DbKey)this.jobTypeKey, (DbKey)this.jobKey);
        this.activatableColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.JOB_ACTIVATABLE, dbContext, this.typeJobKey, (DbValue)DbNil.INSTANCE);
        this.deadlineKey = new DbLong();
        this.deadlineJobKey = new DbCompositeKey((DbKey)this.deadlineKey, (DbKey)this.jobKey);
        this.deadlinesColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.JOB_DEADLINES, dbContext, this.deadlineJobKey, (DbValue)DbNil.INSTANCE);
    }

    public void create(long key, JobRecord record) {
        DirectBuffer type = record.getTypeBuffer();
        this.createJob(key, record, type);
    }

    private void createJob(long key, JobRecord record, DirectBuffer type) {
        this.resetVariablesAndUpdateJobRecord(key, record);
        this.updateJobState(State.ACTIVATABLE);
        this.makeJobActivatable(type);
    }

    public void activate(long key, JobRecord record) {
        DirectBuffer type = record.getTypeBuffer();
        long deadline = record.getDeadlineLong();
        this.validateParameters(type, deadline);
        this.resetVariablesAndUpdateJobRecord(key, record);
        this.updateJobState(State.ACTIVATED);
        this.makeJobNotActivatable(type);
        this.deadlineKey.wrapLong(deadline);
        this.deadlinesColumnFamily.put(this.deadlineJobKey, (DbValue)DbNil.INSTANCE);
    }

    public void timeout(long key, JobRecord record) {
        DirectBuffer type = record.getTypeBuffer();
        long deadline = record.getDeadlineLong();
        this.validateParameters(type, deadline);
        this.createJob(key, record, type);
        this.removeJobDeadline(deadline);
    }

    public void delete(long key, JobRecord record) {
        DirectBuffer type = record.getTypeBuffer();
        long deadline = record.getDeadlineLong();
        this.jobKey.wrapLong(key);
        this.jobsColumnFamily.delete((DbKey)this.jobKey);
        this.statesJobColumnFamily.delete((DbKey)this.jobKey);
        this.makeJobNotActivatable(type);
        this.removeJobDeadline(deadline);
    }

    public void fail(long key, JobRecord updatedValue) {
        DirectBuffer type = updatedValue.getTypeBuffer();
        long deadline = updatedValue.getDeadlineLong();
        this.validateParameters(type, deadline);
        this.resetVariablesAndUpdateJobRecord(key, updatedValue);
        State newState = updatedValue.getRetries() > 0 ? State.ACTIVATABLE : State.FAILED;
        this.updateJobState(newState);
        if (newState == State.ACTIVATABLE) {
            this.makeJobActivatable(type);
        }
        this.removeJobDeadline(deadline);
    }

    private void validateParameters(DirectBuffer type, long deadline) {
        EnsureUtil.ensureNotNullOrEmpty((String)"type", (DirectBuffer)type);
        EnsureUtil.ensureGreaterThan((String)"deadline", (long)deadline, (long)0L);
    }

    public void resolve(long key, JobRecord updatedValue) {
        DirectBuffer type = updatedValue.getTypeBuffer();
        this.resetVariablesAndUpdateJobRecord(key, updatedValue);
        this.updateJobState(State.ACTIVATABLE);
        this.makeJobActivatable(type);
    }

    public void forEachTimedOutEntry(long upperBound, BiFunction<Long, JobRecord, Boolean> callback) {
        this.deadlinesColumnFamily.whileTrue((compositeKey, zbNil) -> {
            boolean isDue;
            long deadline = ((DbLong)compositeKey.getFirst()).getValue();
            boolean bl = isDue = deadline < upperBound;
            if (isDue) {
                long jobKey = ((DbLong)compositeKey.getSecond()).getValue();
                return this.visitJob(jobKey, callback);
            }
            return false;
        });
    }

    public boolean exists(long jobKey) {
        this.jobKey.wrapLong(jobKey);
        return this.jobsColumnFamily.exists((DbKey)this.jobKey);
    }

    public State getState(long key) {
        this.jobKey.wrapLong(key);
        DbByte storedState = (DbByte)this.statesJobColumnFamily.get((DbKey)this.jobKey);
        if (storedState == null) {
            return State.NOT_FOUND;
        }
        return State.forValue(storedState.getValue());
    }

    public boolean isInState(long key, State state) {
        return this.getState(key) == state;
    }

    public void forEachActivatableJobs(DirectBuffer type, BiFunction<Long, JobRecord, Boolean> callback) {
        this.jobTypeKey.wrapBuffer(type);
        this.activatableColumnFamily.whileEqualPrefix((DbKey)this.jobTypeKey, (compositeKey, zbNil) -> {
            long jobKey = ((DbLong)compositeKey.getSecond()).getValue();
            return this.visitJob(jobKey, callback);
        });
    }

    boolean visitJob(long jobKey, BiFunction<Long, JobRecord, Boolean> callback) {
        JobRecord job = this.getJob(jobKey);
        if (job == null) {
            throw new IllegalStateException(String.format("Expected to find job with key %d, but no job found", jobKey));
        }
        return callback.apply(jobKey, job);
    }

    public JobRecord updateJobRetries(long jobKey, int retries) {
        JobRecord job = this.getJob(jobKey);
        if (job != null) {
            job.setRetries(retries);
            this.resetVariablesAndUpdateJobRecord(jobKey, job);
        }
        return job;
    }

    public JobRecord getJob(long key) {
        this.jobKey.wrapLong(key);
        UnpackedObjectValue unpackedObjectValue = (UnpackedObjectValue)this.jobsColumnFamily.get((DbKey)this.jobKey);
        return unpackedObjectValue == null ? null : (JobRecord)unpackedObjectValue.getObject();
    }

    private void resetVariablesAndUpdateJobRecord(long key, JobRecord updatedValue) {
        this.jobKey.wrapLong(key);
        updatedValue.resetVariables();
        this.jobRecordToWrite.wrapObject((UnpackedObject)updatedValue);
        this.jobsColumnFamily.put((DbKey)this.jobKey, (DbValue)this.jobRecordToWrite);
    }

    private void updateJobState(State newState) {
        this.jobState.wrapByte(newState.value);
        this.statesJobColumnFamily.put((DbKey)this.jobKey, (DbValue)this.jobState);
    }

    private void makeJobActivatable(DirectBuffer type) {
        EnsureUtil.ensureNotNullOrEmpty((String)"type", (DirectBuffer)type);
        this.jobTypeKey.wrapBuffer(type);
        this.activatableColumnFamily.put(this.typeJobKey, (DbValue)DbNil.INSTANCE);
    }

    private void makeJobNotActivatable(DirectBuffer type) {
        EnsureUtil.ensureNotNullOrEmpty((String)"type", (DirectBuffer)type);
        this.jobTypeKey.wrapBuffer(type);
        this.activatableColumnFamily.delete(this.typeJobKey);
    }

    private void removeJobDeadline(long deadline) {
        this.deadlineKey.wrapLong(deadline);
        this.deadlinesColumnFamily.delete(this.deadlineJobKey);
    }

    public static enum State {
        ACTIVATABLE(0),
        ACTIVATED(1),
        FAILED(2),
        NOT_FOUND(3);

        byte value;

        private State(byte value) {
            this.value = value;
        }

        static State forValue(byte value) {
            switch (value) {
                case 0: {
                    return ACTIVATABLE;
                }
                case 1: {
                    return ACTIVATED;
                }
                case 2: {
                    return FAILED;
                }
            }
            return NOT_FOUND;
        }
    }
}

