/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.instance;

import io.zeebe.db.DbValue;
import io.zeebe.engine.state.instance.IndexedRecord;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class StoredRecord
implements DbValue {
    private static final int PURPOSE_OFFSET = 0;
    private static final int PURPOSE_LENGTH = 1;
    private static final int RECORD_OFFSET = 1;
    private final IndexedRecord record;
    private Purpose purpose;

    public StoredRecord(IndexedRecord record, Purpose purpose) {
        this.record = record;
        this.purpose = purpose;
    }

    public StoredRecord() {
        this.record = new IndexedRecord();
    }

    public IndexedRecord getRecord() {
        return this.record;
    }

    public Purpose getPurpose() {
        return this.purpose;
    }

    public long getKey() {
        return this.record.getKey();
    }

    public int getLength() {
        return 1 + this.record.getLength();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        buffer.putByte(0, (byte)this.purpose.ordinal());
        this.record.write(buffer, 1);
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        byte purposeOrdinal = buffer.getByte(offset + 0);
        this.purpose = Purpose.values()[purposeOrdinal];
        this.record.wrap(buffer, offset + 1, length - 1);
    }

    public static enum Purpose {
        DEFERRED,
        FAILED;

    }
}

