/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.instance;

import io.zeebe.db.DbValue;
import io.zeebe.db.impl.ZeebeDbConstants;
import io.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class TimerInstance
implements DbValue {
    public static final int NO_ELEMENT_INSTANCE = -1;
    private final DirectBuffer handlerNodeId = new UnsafeBuffer(0L, 0);
    private long workflowKey;
    private long key;
    private long elementInstanceKey;
    private long workflowInstanceKey;
    private long dueDate;
    private int repetitions;

    public long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    public void setElementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
    }

    public long getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(long dueDate) {
        this.dueDate = dueDate;
    }

    public long getKey() {
        return this.key;
    }

    public void setKey(long key) {
        this.key = key;
    }

    public DirectBuffer getHandlerNodeId() {
        return this.handlerNodeId;
    }

    public void setHandlerNodeId(DirectBuffer handlerNodeId) {
        this.handlerNodeId.wrap(handlerNodeId);
    }

    public int getRepetitions() {
        return this.repetitions;
    }

    public void setRepetitions(int repetitions) {
        this.repetitions = repetitions;
    }

    public long getWorkflowKey() {
        return this.workflowKey;
    }

    public void setWorkflowKey(long workflowKey) {
        this.workflowKey = workflowKey;
    }

    public long getWorkflowInstanceKey() {
        return this.workflowInstanceKey;
    }

    public void setWorkflowInstanceKey(long workflowInstanceKey) {
        this.workflowInstanceKey = workflowInstanceKey;
    }

    public int getLength() {
        return 48 + this.handlerNodeId.capacity();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        buffer.putLong(offset, this.elementInstanceKey, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        buffer.putLong(offset += 8, this.workflowInstanceKey, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        buffer.putLong(offset += 8, this.dueDate, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        buffer.putLong(offset += 8, this.key, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        buffer.putLong(offset += 8, this.workflowKey, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        buffer.putInt(offset += 8, this.repetitions, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        offset += 4;
        offset = BufferUtil.writeIntoBuffer((MutableDirectBuffer)buffer, (int)offset, (DirectBuffer)this.handlerNodeId);
        assert (offset == this.getLength()) : "End offset differs from getLength()";
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.elementInstanceKey = buffer.getLong(offset, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        this.workflowInstanceKey = buffer.getLong(offset += 8, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        this.dueDate = buffer.getLong(offset += 8, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        this.key = buffer.getLong(offset += 8, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        this.workflowKey = buffer.getLong(offset += 8, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        this.repetitions = buffer.getInt(offset += 8, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        offset += 4;
        offset = BufferUtil.readIntoBuffer((DirectBuffer)buffer, (int)offset, (DirectBuffer)this.handlerNodeId);
        assert (offset == length) : "End offset differs from length";
    }
}

