/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.instance;

import io.zeebe.db.ColumnFamily;
import io.zeebe.db.DbContext;
import io.zeebe.db.DbKey;
import io.zeebe.db.DbValue;
import io.zeebe.db.ZeebeDb;
import io.zeebe.db.impl.DbCompositeKey;
import io.zeebe.db.impl.DbLong;
import io.zeebe.db.impl.DbNil;
import io.zeebe.engine.state.ZbColumnFamilies;
import io.zeebe.engine.state.instance.TimerInstance;
import java.util.function.Consumer;

public class TimerInstanceState {
    private final ColumnFamily<DbCompositeKey<DbLong, DbLong>, TimerInstance> timerInstanceColumnFamily;
    private final TimerInstance timerInstance = new TimerInstance();
    private final DbLong timerKey = new DbLong();
    private final DbLong elementInstanceKey = new DbLong();
    private final DbCompositeKey<DbLong, DbLong> elementAndTimerKey = new DbCompositeKey((DbKey)this.elementInstanceKey, (DbKey)this.timerKey);
    private final ColumnFamily<DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbLong>>, DbNil> dueDateColumnFamily;
    private final DbLong dueDateKey;
    private final DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbLong>> dueDateCompositeKey;
    private long nextDueDate;

    public TimerInstanceState(ZeebeDb<ZbColumnFamilies> zeebeDb, DbContext dbContext) {
        this.timerInstanceColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.TIMERS, dbContext, this.elementAndTimerKey, (DbValue)this.timerInstance);
        this.dueDateKey = new DbLong();
        this.dueDateCompositeKey = new DbCompositeKey((DbKey)this.dueDateKey, this.elementAndTimerKey);
        this.dueDateColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.TIMER_DUE_DATES, dbContext, this.dueDateCompositeKey, (DbValue)DbNil.INSTANCE);
    }

    public void put(TimerInstance timer) {
        this.timerKey.wrapLong(timer.getKey());
        this.elementInstanceKey.wrapLong(timer.getElementInstanceKey());
        this.timerInstanceColumnFamily.put(this.elementAndTimerKey, (DbValue)timer);
        this.dueDateKey.wrapLong(timer.getDueDate());
        this.dueDateColumnFamily.put(this.dueDateCompositeKey, (DbValue)DbNil.INSTANCE);
    }

    public long findTimersWithDueDateBefore(long timestamp, TimerVisitor consumer) {
        this.nextDueDate = -1L;
        this.dueDateColumnFamily.whileTrue((key, nil) -> {
            DbLong dueDate = (DbLong)key.getFirst();
            boolean consumed = false;
            if (dueDate.getValue() <= timestamp) {
                DbCompositeKey elementAndTimerKey = (DbCompositeKey)key.getSecond();
                TimerInstance timerInstance = (TimerInstance)this.timerInstanceColumnFamily.get((DbKey)elementAndTimerKey);
                consumed = consumer.visit(timerInstance);
            }
            if (!consumed) {
                this.nextDueDate = dueDate.getValue();
            }
            return consumed;
        });
        return this.nextDueDate;
    }

    public void forEachTimerForElementInstance(long elementInstanceKey, Consumer<TimerInstance> action) {
        this.elementInstanceKey.wrapLong(elementInstanceKey);
        this.timerInstanceColumnFamily.whileEqualPrefix((DbKey)this.elementInstanceKey, (key, value) -> action.accept((TimerInstance)value));
    }

    public TimerInstance get(long elementInstanceKey, long timerKey) {
        this.elementInstanceKey.wrapLong(elementInstanceKey);
        this.timerKey.wrapLong(timerKey);
        return (TimerInstance)this.timerInstanceColumnFamily.get(this.elementAndTimerKey);
    }

    public void remove(TimerInstance timer) {
        this.elementInstanceKey.wrapLong(timer.getElementInstanceKey());
        this.timerKey.wrapLong(timer.getKey());
        this.timerInstanceColumnFamily.delete(this.elementAndTimerKey);
        this.dueDateKey.wrapLong(timer.getDueDate());
        this.dueDateColumnFamily.delete(this.dueDateCompositeKey);
    }

    @FunctionalInterface
    public static interface TimerVisitor {
        public boolean visit(TimerInstance var1);
    }
}

