/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.instance;

import io.zeebe.db.ColumnFamily;
import io.zeebe.db.DbContext;
import io.zeebe.db.DbKey;
import io.zeebe.db.DbValue;
import io.zeebe.db.ZeebeDb;
import io.zeebe.db.impl.DbBuffer;
import io.zeebe.db.impl.DbCompositeKey;
import io.zeebe.db.impl.DbLong;
import io.zeebe.db.impl.DbString;
import io.zeebe.engine.processor.KeyGenerator;
import io.zeebe.engine.state.ZbColumnFamilies;
import io.zeebe.engine.state.instance.VariableInstance;
import io.zeebe.msgpack.spec.MsgPackReader;
import io.zeebe.msgpack.spec.MsgPackToken;
import io.zeebe.msgpack.spec.MsgPackWriter;
import io.zeebe.util.buffer.BufferUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.BiConsumer;
import java.util.function.BooleanSupplier;
import java.util.function.Predicate;
import org.agrona.DirectBuffer;
import org.agrona.ExpandableArrayBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.Int2IntHashMap;
import org.agrona.collections.ObjectHashSet;
import org.agrona.concurrent.UnsafeBuffer;

public class VariablesState {
    public static final int NO_PARENT = -1;
    private final MsgPackReader reader = new MsgPackReader();
    private final MsgPackWriter writer = new MsgPackWriter();
    private final ExpandableArrayBuffer documentResultBuffer = new ExpandableArrayBuffer();
    private final DirectBuffer resultView = new UnsafeBuffer(0L, 0);
    private final ColumnFamily<DbLong, DbLong> childParentColumnFamily;
    private final DbLong parentKey;
    private final DbLong childKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbString>, VariableInstance> variablesColumnFamily;
    private final DbCompositeKey<DbLong, DbString> scopeKeyVariableNameKey;
    private final DbLong scopeKey;
    private final DbString variableName;
    private final ColumnFamily<DbLong, DbBuffer> temporaryVariableStoreColumnFamily;
    private final DbBuffer temporaryVariables = new DbBuffer();
    private final VariableInstance newVariable = new VariableInstance();
    private final DirectBuffer variableNameView = new UnsafeBuffer(0L, 0);
    private final ObjectHashSet<DirectBuffer> collectedVariables = new ObjectHashSet();
    private final ObjectHashSet<DirectBuffer> variablesToCollect = new ObjectHashSet();
    private final IndexedDocument indexedDocument = new IndexedDocument();
    private final KeyGenerator keyGenerator;
    private VariableListener listener;
    private int variableCount = 0;

    public VariablesState(ZeebeDb<ZbColumnFamilies> zeebeDb, DbContext dbContext, KeyGenerator keyGenerator) {
        this.keyGenerator = keyGenerator;
        this.parentKey = new DbLong();
        this.childKey = new DbLong();
        this.childParentColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.ELEMENT_INSTANCE_CHILD_PARENT, dbContext, (DbKey)this.childKey, (DbValue)this.parentKey);
        this.scopeKey = new DbLong();
        this.variableName = new DbString();
        this.scopeKeyVariableNameKey = new DbCompositeKey((DbKey)this.scopeKey, (DbKey)this.variableName);
        this.variablesColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.VARIABLES, dbContext, this.scopeKeyVariableNameKey, (DbValue)new VariableInstance());
        this.temporaryVariableStoreColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.TEMPORARY_VARIABLE_STORE, dbContext, (DbKey)this.scopeKey, (DbValue)this.temporaryVariables);
    }

    public void setVariablesLocalFromDocument(long scopeKey, long workflowKey, DirectBuffer document) {
        this.reader.wrap(document, 0, document.capacity());
        int variables = this.reader.readMapHeader();
        for (int i = 0; i < variables; ++i) {
            MsgPackToken variableName = this.reader.readToken();
            int nameLength = variableName.getValueBuffer().capacity();
            int nameOffset = this.reader.getOffset() - nameLength;
            int valueOffset = this.reader.getOffset();
            this.reader.skipValue();
            int valueLength = this.reader.getOffset() - valueOffset;
            this.setVariableLocal(scopeKey, workflowKey, document, nameOffset, nameLength, document, valueOffset, valueLength);
        }
    }

    void setVariableLocal(long scopeKey, long workflowKey, DirectBuffer name, int nameOffset, int nameLength, DirectBuffer value, int valueOffset, int valueLength) {
        this.newVariable.reset();
        this.newVariable.setValue(value, valueOffset, valueLength);
        VariableInstance currentVariable = this.getVariableLocal(scopeKey, name, nameOffset, nameLength);
        if (currentVariable == null) {
            this.newVariable.setKey(this.keyGenerator.nextKey());
            this.variablesColumnFamily.put(this.scopeKeyVariableNameKey, (DbValue)this.newVariable);
            if (this.listener != null) {
                long rootScopeKey = this.getRootScopeKey(scopeKey);
                this.listener.onCreate(this.newVariable.getKey(), workflowKey, this.variableName.getBuffer(), this.newVariable.getValue(), scopeKey, rootScopeKey);
            }
        } else if (!BufferUtil.equals((DirectBuffer)currentVariable.getValue(), (DirectBuffer)this.newVariable.getValue())) {
            this.newVariable.setKey(currentVariable.getKey());
            this.variablesColumnFamily.put(this.scopeKeyVariableNameKey, (DbValue)this.newVariable);
            if (this.listener != null) {
                long rootScopeKey = this.getRootScopeKey(scopeKey);
                this.listener.onUpdate(this.newVariable.getKey(), workflowKey, this.variableName.getBuffer(), this.newVariable.getValue(), scopeKey, rootScopeKey);
            }
        }
    }

    private boolean hasVariableLocal(long scopeKey, DirectBuffer name, int nameOffset, int nameLength) {
        this.scopeKey.wrapLong(scopeKey);
        this.variableNameView.wrap(name, nameOffset, nameLength);
        this.variableName.wrapBuffer(this.variableNameView);
        return this.variablesColumnFamily.exists(this.scopeKeyVariableNameKey);
    }

    public DirectBuffer getVariableLocal(long scopeKey, DirectBuffer name) {
        VariableInstance variable = this.getVariableLocal(scopeKey, name, 0, name.capacity());
        if (variable != null) {
            return variable.getValue();
        }
        return null;
    }

    private VariableInstance getVariableLocal(long scopeKey, DirectBuffer name, int nameOffset, int nameLength) {
        this.scopeKey.wrapLong(scopeKey);
        this.variableNameView.wrap(name, nameOffset, nameLength);
        this.variableName.wrapBuffer(this.variableNameView);
        return (VariableInstance)this.variablesColumnFamily.get(this.scopeKeyVariableNameKey);
    }

    public void setVariablesFromDocument(long scopeKey, long workflowKey, DirectBuffer document) {
        DocumentEntryIterator entryIterator;
        long parentScope;
        this.indexedDocument.index(document);
        long currentScope = scopeKey;
        while (this.indexedDocument.hasEntries() && (parentScope = this.getParent(currentScope)) > 0L) {
            entryIterator = this.indexedDocument.iterator();
            while (entryIterator.hasNext()) {
                entryIterator.next();
                boolean hasVariable = this.hasVariableLocal(currentScope, document, entryIterator.getNameOffset(), entryIterator.getNameLength());
                if (!hasVariable) continue;
                this.setVariableLocal(currentScope, workflowKey, document, entryIterator.getNameOffset(), entryIterator.getNameLength(), document, entryIterator.getValueOffset(), entryIterator.getValueLength());
                entryIterator.remove();
            }
            currentScope = parentScope;
        }
        if (this.indexedDocument.hasEntries()) {
            entryIterator = this.indexedDocument.iterator();
            while (entryIterator.hasNext()) {
                entryIterator.next();
                this.setVariableLocal(currentScope, workflowKey, document, entryIterator.getNameOffset(), entryIterator.getNameLength(), document, entryIterator.getValueOffset(), entryIterator.getValueLength());
            }
        }
    }

    private long getParent(long childKey) {
        this.childKey.wrapLong(childKey);
        DbLong parentKey = (DbLong)this.childParentColumnFamily.get((DbKey)this.childKey);
        return parentKey != null ? parentKey.getValue() : -1L;
    }

    public DirectBuffer getVariablesAsDocument(long scopeKey) {
        this.collectedVariables.clear();
        this.writer.wrap((MutableDirectBuffer)this.documentResultBuffer, 0);
        this.writer.reserveMapHeader();
        this.visitVariables(scopeKey, name -> !this.collectedVariables.contains((Object)name.getBuffer()), (name, value) -> {
            DirectBuffer variableNameBuffer = name.getBuffer();
            this.writer.writeString(variableNameBuffer);
            this.writer.writeRaw(value.getValue());
            UnsafeBuffer nameView = new UnsafeBuffer(variableNameBuffer);
            this.collectedVariables.add((Object)nameView);
        }, () -> false);
        this.writer.writeReservedMapHeader(0, this.collectedVariables.size());
        this.resultView.wrap((DirectBuffer)this.documentResultBuffer, 0, this.writer.getOffset());
        return this.resultView;
    }

    public DirectBuffer getVariablesAsDocument(long scopeKey, Collection<DirectBuffer> names) {
        this.variablesToCollect.clear();
        this.variablesToCollect.addAll(names);
        this.writer.wrap((MutableDirectBuffer)this.documentResultBuffer, 0);
        this.writer.reserveMapHeader();
        this.visitVariables(scopeKey, name -> this.variablesToCollect.contains((Object)name.getBuffer()), (name, value) -> {
            this.writer.writeString(name.getBuffer());
            this.writer.writeRaw(value.getValue());
            this.variablesToCollect.remove((Object)name.getBuffer());
        }, () -> this.variablesToCollect.isEmpty());
        this.writer.writeReservedMapHeader(0, names.size() - this.variablesToCollect.size());
        this.resultView.wrap((DirectBuffer)this.documentResultBuffer, 0, this.writer.getOffset());
        return this.resultView;
    }

    public DirectBuffer getVariablesLocalAsDocument(long scopeKey) {
        this.writer.wrap((MutableDirectBuffer)this.documentResultBuffer, 0);
        this.writer.reserveMapHeader();
        this.variableCount = 0;
        this.visitVariablesLocal(scopeKey, name -> true, (name, value) -> {
            this.writer.writeString(name.getBuffer());
            this.writer.writeRaw(value.getValue());
            ++this.variableCount;
        }, () -> false);
        this.writer.writeReservedMapHeader(0, this.variableCount);
        this.resultView.wrap((DirectBuffer)this.documentResultBuffer, 0, this.writer.getOffset());
        return this.resultView;
    }

    private void visitVariables(long scopeKey, Predicate<DbString> filter, BiConsumer<DbString, VariableInstance> variableConsumer, BooleanSupplier completionCondition) {
        boolean completed;
        long currentScope = scopeKey;
        do {
            completed = this.visitVariablesLocal(currentScope, filter, variableConsumer, completionCondition);
            currentScope = this.getParent(currentScope);
        } while (!completed && currentScope >= 0L);
    }

    private boolean visitVariablesLocal(long scopeKey, Predicate<DbString> variableFilter, BiConsumer<DbString, VariableInstance> variableConsumer, BooleanSupplier completionCondition) {
        this.scopeKey.wrapLong(scopeKey);
        this.variablesColumnFamily.whileEqualPrefix((DbKey)this.scopeKey, (compositeKey, variable) -> {
            DbString variableName = (DbString)compositeKey.getSecond();
            if (variableFilter.test(variableName)) {
                variableConsumer.accept(variableName, (VariableInstance)variable);
            }
            return !completionCondition.getAsBoolean();
        });
        return false;
    }

    public void createScope(long childKey, long parentKey) {
        this.childKey.wrapLong(childKey);
        this.parentKey.wrapLong(parentKey);
        this.childParentColumnFamily.put((DbKey)this.childKey, (DbValue)this.parentKey);
    }

    public void removeScope(long scopeKey) {
        this.scopeKey.wrapLong(scopeKey);
        this.removeAllVariables(scopeKey);
        this.childParentColumnFamily.delete((DbKey)this.scopeKey);
    }

    public void removeAllVariables(long scopeKey) {
        this.visitVariablesLocal(scopeKey, dbString -> true, (dbString, variable1) -> this.variablesColumnFamily.delete(this.scopeKeyVariableNameKey), () -> false);
    }

    public void setTemporaryVariables(long scopeKey, DirectBuffer variables) {
        this.scopeKey.wrapLong(scopeKey);
        this.temporaryVariables.wrapBuffer(variables);
        this.temporaryVariableStoreColumnFamily.put((DbKey)this.scopeKey, (DbValue)this.temporaryVariables);
    }

    public DirectBuffer getTemporaryVariables(long scopeKey) {
        this.scopeKey.wrapLong(scopeKey);
        DbBuffer variables = (DbBuffer)this.temporaryVariableStoreColumnFamily.get((DbKey)this.scopeKey);
        return variables == null ? null : variables.getValue();
    }

    public void removeTemporaryVariables(long scopeKey) {
        this.scopeKey.wrapLong(scopeKey);
        this.temporaryVariableStoreColumnFamily.delete((DbKey)this.scopeKey);
    }

    public boolean isEmpty() {
        return this.variablesColumnFamily.isEmpty() && this.childParentColumnFamily.isEmpty() && this.temporaryVariableStoreColumnFamily.isEmpty();
    }

    public void setListener(VariableListener listener) {
        if (this.listener != null) {
            throw new IllegalStateException("variable listener is already set");
        }
        this.listener = listener;
    }

    private long getRootScopeKey(long scopeKey) {
        long rootScopeKey = scopeKey;
        long currentScopeKey = scopeKey;
        do {
            if ((currentScopeKey = this.getParent(currentScopeKey)) == -1L) continue;
            rootScopeKey = currentScopeKey;
        } while (currentScopeKey != -1L);
        return rootScopeKey;
    }

    public static interface VariableListener {
        public void onCreate(long var1, long var3, DirectBuffer var5, DirectBuffer var6, long var7, long var9);

        public void onUpdate(long var1, long var3, DirectBuffer var5, DirectBuffer var6, long var7, long var9);
    }

    private class DocumentEntryIterator
    implements Iterator<Void> {
        private Int2IntHashMap.EntryIterator iterator;
        private DirectBuffer document;
        private int documentLength;
        private int nameOffset;
        private int nameLength;
        private int valueOffset;
        private int valueLength;

        private DocumentEntryIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        public void wrap(DirectBuffer document, Int2IntHashMap.EntryIterator iterator) {
            this.iterator = iterator;
            this.document = document;
            this.documentLength = document.capacity();
        }

        public int getNameOffset() {
            return this.nameOffset;
        }

        public int getNameLength() {
            return this.nameLength;
        }

        public int getValueOffset() {
            return this.valueOffset;
        }

        public int getValueLength() {
            return this.valueLength;
        }

        @Override
        public Void next() {
            this.iterator.next();
            int keyOffset = this.iterator.getIntKey();
            this.valueOffset = this.iterator.getIntValue();
            VariablesState.this.reader.wrap(this.document, keyOffset, this.documentLength - keyOffset);
            this.nameLength = VariablesState.this.reader.readStringLength();
            this.nameOffset = keyOffset + VariablesState.this.reader.getOffset();
            VariablesState.this.reader.wrap(this.document, this.valueOffset, this.documentLength - this.valueOffset);
            VariablesState.this.reader.skipValue();
            this.valueLength = VariablesState.this.reader.getOffset();
            return null;
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private class IndexedDocument
    implements Iterable<Void> {
        private final Int2IntHashMap entries = new Int2IntHashMap(-1);
        private final DocumentEntryIterator iterator = new DocumentEntryIterator();
        private DirectBuffer document;

        private IndexedDocument() {
        }

        public void index(DirectBuffer document) {
            this.document = document;
            this.entries.clear();
            int documentLength = document.capacity();
            VariablesState.this.reader.wrap(document, 0, documentLength);
            int variables = VariablesState.this.reader.readMapHeader();
            for (int i = 0; i < variables; ++i) {
                int keyOffset = VariablesState.this.reader.getOffset();
                VariablesState.this.reader.skipValue();
                int valueOffset = VariablesState.this.reader.getOffset();
                VariablesState.this.reader.skipValue();
                this.entries.put(keyOffset, valueOffset);
            }
        }

        public DocumentEntryIterator iterator() {
            this.iterator.wrap(this.document, this.entries.entrySet().iterator());
            return this.iterator;
        }

        public boolean hasEntries() {
            return !this.entries.isEmpty();
        }
    }
}

