/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.instance;

import io.zeebe.engine.processor.ReadonlyProcessingContext;
import io.zeebe.engine.processor.StreamProcessorLifecycleAware;
import io.zeebe.engine.processor.workflow.UpdateVariableStreamWriter;
import io.zeebe.engine.processor.workflow.WorkflowInstanceLifecycle;
import io.zeebe.engine.processor.workflow.WorkflowInstanceMetrics;
import io.zeebe.engine.state.deployment.WorkflowState;
import io.zeebe.engine.state.instance.ElementInstance;
import io.zeebe.engine.state.instance.ElementInstanceState;
import io.zeebe.engine.state.instance.StoredRecord;
import io.zeebe.logstreams.log.LogStream;
import io.zeebe.protocol.impl.record.value.workflowinstance.WorkflowInstanceRecord;
import io.zeebe.protocol.record.intent.WorkflowInstanceIntent;
import io.zeebe.util.metrics.MetricsManager;

public class WorkflowEngineState
implements StreamProcessorLifecycleAware {
    private final WorkflowState workflowState;
    private ElementInstanceState elementInstanceState;
    private WorkflowInstanceMetrics metrics;

    public WorkflowEngineState(WorkflowState workflowState) {
        this.workflowState = workflowState;
    }

    @Override
    public void onOpen(ReadonlyProcessingContext processingContext) {
        MetricsManager metricsManager = processingContext.getMetricsManager();
        LogStream logStream = processingContext.getLogStream();
        this.metrics = new WorkflowInstanceMetrics(metricsManager, logStream.getPartitionId());
        this.elementInstanceState = this.workflowState.getElementInstanceState();
        UpdateVariableStreamWriter updateVariableStreamWriter = new UpdateVariableStreamWriter(processingContext.getLogStreamWriter());
        this.elementInstanceState.getVariablesState().setListener(updateVariableStreamWriter);
    }

    @Override
    public void onClose() {
        this.metrics.close();
    }

    public void onEventProduced(long key, WorkflowInstanceIntent state, WorkflowInstanceRecord value) {
        if (WorkflowInstanceLifecycle.isElementInstanceState(state)) {
            this.onElementInstanceEventProduced(key, state, value);
        }
    }

    public void deferRecord(long key, long scopeKey, WorkflowInstanceRecord value, WorkflowInstanceIntent state) {
        this.elementInstanceState.storeRecord(key, scopeKey, value, state, StoredRecord.Purpose.DEFERRED);
    }

    public void removeStoredRecord(long scopeKey, long key, StoredRecord.Purpose purpose) {
        this.elementInstanceState.removeStoredRecord(scopeKey, key, purpose);
    }

    private void onElementInstanceEventProduced(long key, WorkflowInstanceIntent state, WorkflowInstanceRecord value) {
        if (WorkflowInstanceLifecycle.isInitialState(state)) {
            this.createNewElementInstance(key, state, value);
        } else {
            this.updateElementInstance(key, state, value);
        }
        this.recordElementInstanceMetrics(key, state, value);
    }

    private void updateElementInstance(long key, WorkflowInstanceIntent state, WorkflowInstanceRecord value) {
        ElementInstance scopeInstance = this.elementInstanceState.getInstance(key);
        scopeInstance.setState(state);
        scopeInstance.setValue(value);
        this.elementInstanceState.updateInstance(scopeInstance);
    }

    private void createNewElementInstance(long key, WorkflowInstanceIntent state, WorkflowInstanceRecord value) {
        long flowScopeKey = value.getFlowScopeKey();
        if (flowScopeKey >= 0L) {
            ElementInstance flowScopeInstance = this.elementInstanceState.getInstance(flowScopeKey);
            this.elementInstanceState.newInstance(flowScopeInstance, key, value, state);
        } else {
            this.elementInstanceState.newInstance(key, value, state);
        }
    }

    private void recordElementInstanceMetrics(long key, WorkflowInstanceIntent state, WorkflowInstanceRecord value) {
        if (key == value.getWorkflowInstanceKey()) {
            if (state == WorkflowInstanceIntent.ELEMENT_TERMINATED) {
                this.metrics.countInstanceCanceled();
            } else if (state == WorkflowInstanceIntent.ELEMENT_COMPLETED) {
                this.metrics.countInstanceCompleted();
            } else if (state == WorkflowInstanceIntent.ELEMENT_ACTIVATED) {
                this.metrics.countInstanceCreated();
            }
        }
    }

    public WorkflowState getWorkflowState() {
        return this.workflowState;
    }

    public ElementInstanceState getElementInstanceState() {
        return this.workflowState.getElementInstanceState();
    }

    public void storeFailedRecord(long key, WorkflowInstanceRecord recordValue, WorkflowInstanceIntent intent) {
        long scopeKey = recordValue.getFlowScopeKey();
        this.elementInstanceState.storeRecord(key, scopeKey, recordValue, intent, StoredRecord.Purpose.FAILED);
    }
}

