/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.message;

import io.zeebe.db.DbValue;
import io.zeebe.db.impl.ZeebeDbConstants;
import io.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public final class Message
implements DbValue {
    private final DirectBuffer name = new UnsafeBuffer();
    private final DirectBuffer correlationKey = new UnsafeBuffer();
    private final DirectBuffer variables = new UnsafeBuffer();
    private final DirectBuffer id = new UnsafeBuffer();
    private long key;
    private long timeToLive;
    private long deadline;

    public Message() {
    }

    public Message(long key, DirectBuffer name, DirectBuffer correlationKey, DirectBuffer variables, DirectBuffer id, long timeToLive, long deadline) {
        this.name.wrap(name);
        this.correlationKey.wrap(correlationKey);
        this.variables.wrap(variables);
        this.id.wrap(id);
        this.key = key;
        this.timeToLive = timeToLive;
        this.deadline = deadline;
    }

    public DirectBuffer getName() {
        return this.name;
    }

    public DirectBuffer getCorrelationKey() {
        return this.correlationKey;
    }

    public DirectBuffer getVariables() {
        return this.variables;
    }

    public DirectBuffer getId() {
        return this.id;
    }

    public long getTimeToLive() {
        return this.timeToLive;
    }

    public long getDeadline() {
        return this.deadline;
    }

    public long getKey() {
        return this.key;
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        offset = BufferUtil.readIntoBuffer((DirectBuffer)buffer, (int)offset, (DirectBuffer)this.name);
        offset = BufferUtil.readIntoBuffer((DirectBuffer)buffer, (int)offset, (DirectBuffer)this.correlationKey);
        offset = BufferUtil.readIntoBuffer((DirectBuffer)buffer, (int)offset, (DirectBuffer)this.variables);
        offset = BufferUtil.readIntoBuffer((DirectBuffer)buffer, (int)offset, (DirectBuffer)this.id);
        this.timeToLive = buffer.getLong(offset, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        this.deadline = buffer.getLong(offset += 8, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        this.key = buffer.getLong(offset += 8, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
    }

    public int getLength() {
        return this.name.capacity() + this.correlationKey.capacity() + this.variables.capacity() + this.id.capacity() + 16 + 24;
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        int valueOffset = offset;
        valueOffset = BufferUtil.writeIntoBuffer((MutableDirectBuffer)buffer, (int)valueOffset, (DirectBuffer)this.name);
        valueOffset = BufferUtil.writeIntoBuffer((MutableDirectBuffer)buffer, (int)valueOffset, (DirectBuffer)this.correlationKey);
        valueOffset = BufferUtil.writeIntoBuffer((MutableDirectBuffer)buffer, (int)valueOffset, (DirectBuffer)this.variables);
        valueOffset = BufferUtil.writeIntoBuffer((MutableDirectBuffer)buffer, (int)valueOffset, (DirectBuffer)this.id);
        buffer.putLong(valueOffset, this.timeToLive, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        buffer.putLong(valueOffset += 8, this.deadline, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        buffer.putLong(valueOffset += 8, this.key, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        assert ((valueOffset += 8) - offset == this.getLength()) : "End offset differs with getLength()";
    }
}

