/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.message;

import io.zeebe.db.ColumnFamily;
import io.zeebe.db.DbContext;
import io.zeebe.db.DbKey;
import io.zeebe.db.DbValue;
import io.zeebe.db.ZeebeDb;
import io.zeebe.db.impl.DbCompositeKey;
import io.zeebe.db.impl.DbLong;
import io.zeebe.db.impl.DbNil;
import io.zeebe.db.impl.DbString;
import io.zeebe.engine.state.ZbColumnFamilies;
import io.zeebe.engine.state.instance.UnpackedObjectValue;
import io.zeebe.msgpack.UnpackedObject;
import io.zeebe.protocol.impl.record.value.message.MessageStartEventSubscriptionRecord;
import org.agrona.DirectBuffer;

public class MessageStartEventSubscriptionState {
    private final DbString messageName = new DbString();
    private final DbLong workflowKey = new DbLong();
    private final DbCompositeKey<DbString, DbLong> messageNameAndWorkflowKey = new DbCompositeKey((DbKey)this.messageName, (DbKey)this.workflowKey);
    private final ColumnFamily<DbCompositeKey<DbString, DbLong>, UnpackedObjectValue> subscriptionsColumnFamily;
    private final UnpackedObjectValue subscriptionValue = new UnpackedObjectValue();
    private final MessageStartEventSubscriptionRecord subscriptionRecord = new MessageStartEventSubscriptionRecord();
    private final DbCompositeKey<DbLong, DbString> workflowKeyAndMessageName;
    private final ColumnFamily<DbCompositeKey<DbLong, DbString>, DbNil> subscriptionsOfWorkflowKeyColumnfamily;

    public MessageStartEventSubscriptionState(ZeebeDb<ZbColumnFamilies> zeebeDb, DbContext dbContext) {
        this.subscriptionValue.wrapObject((UnpackedObject)this.subscriptionRecord);
        this.subscriptionsColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_START_EVENT_SUBSCRIPTION_BY_NAME_AND_KEY, dbContext, this.messageNameAndWorkflowKey, (DbValue)this.subscriptionValue);
        this.workflowKeyAndMessageName = new DbCompositeKey((DbKey)this.workflowKey, (DbKey)this.messageName);
        this.subscriptionsOfWorkflowKeyColumnfamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_START_EVENT_SUBSCRIPTION_BY_KEY_AND_NAME, dbContext, this.workflowKeyAndMessageName, (DbValue)DbNil.INSTANCE);
    }

    public void put(MessageStartEventSubscriptionRecord subscription) {
        this.subscriptionRecord.setStartEventId(subscription.getStartEventIdBuffer());
        this.subscriptionRecord.setMessageName(subscription.getMessageNameBuffer());
        this.subscriptionRecord.setWorkflowKey(subscription.getWorkflowKey());
        this.messageName.wrapBuffer(subscription.getMessageNameBuffer());
        this.workflowKey.wrapLong(subscription.getWorkflowKey());
        this.subscriptionsColumnFamily.put(this.messageNameAndWorkflowKey, (DbValue)this.subscriptionValue);
        this.subscriptionsOfWorkflowKeyColumnfamily.put(this.workflowKeyAndMessageName, (DbValue)DbNil.INSTANCE);
    }

    public void removeSubscriptionsOfWorkflow(long workflowKey) {
        this.workflowKey.wrapLong(workflowKey);
        this.subscriptionsOfWorkflowKeyColumnfamily.whileEqualPrefix((DbKey)this.workflowKey, (key, value) -> {
            this.subscriptionsColumnFamily.delete(this.messageNameAndWorkflowKey);
            this.subscriptionsOfWorkflowKeyColumnfamily.delete((DbKey)key);
        });
    }

    public boolean exists(MessageStartEventSubscriptionRecord subscription) {
        this.messageName.wrapBuffer(subscription.getMessageNameBuffer());
        this.workflowKey.wrapLong(subscription.getWorkflowKey());
        return this.subscriptionsColumnFamily.exists(this.messageNameAndWorkflowKey);
    }

    public void visitSubscriptionsByMessageName(DirectBuffer messageName, MessageStartEventSubscriptionVisitor visitor) {
        this.messageName.wrapBuffer(messageName);
        this.subscriptionsColumnFamily.whileEqualPrefix((DbKey)this.messageName, (key, value) -> visitor.visit((MessageStartEventSubscriptionRecord)value.getObject()));
    }

    @FunctionalInterface
    public static interface MessageStartEventSubscriptionVisitor {
        public void visit(MessageStartEventSubscriptionRecord var1);
    }
}

