/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.message;

import io.zeebe.db.ColumnFamily;
import io.zeebe.db.DbContext;
import io.zeebe.db.DbKey;
import io.zeebe.db.DbValue;
import io.zeebe.db.ZeebeDb;
import io.zeebe.db.impl.DbCompositeKey;
import io.zeebe.db.impl.DbLong;
import io.zeebe.db.impl.DbNil;
import io.zeebe.db.impl.DbString;
import io.zeebe.engine.state.ZbColumnFamilies;
import io.zeebe.engine.state.message.Message;
import org.agrona.DirectBuffer;

public class MessageState {
    private final ColumnFamily<DbLong, Message> messageColumnFamily;
    private final DbLong messageKey = new DbLong();
    private final Message message = new Message();
    private final DbString messageName;
    private final DbString correlationKey;
    private final DbCompositeKey<DbCompositeKey<DbString, DbString>, DbLong> nameCorrelationMessageKey;
    private final DbCompositeKey<DbString, DbString> nameAndCorrelationKey;
    private final ColumnFamily<DbCompositeKey<DbCompositeKey<DbString, DbString>, DbLong>, DbNil> nameCorrelationMessageColumnFamily;
    private final DbLong deadline;
    private final DbCompositeKey<DbLong, DbLong> deadlineMessageKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbLong>, DbNil> deadlineColumnFamily;
    private final DbString messageId;
    private final DbCompositeKey<DbCompositeKey<DbString, DbString>, DbString> nameCorrelationMessageIdKey;
    private final ColumnFamily<DbCompositeKey<DbCompositeKey<DbString, DbString>, DbString>, DbNil> messageIdColumnFamily;
    private final DbCompositeKey<DbLong, DbLong> messageWorkflowKey;
    private final DbLong workflowInstanceKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbLong>, DbNil> correlatedMessageColumnFamily;

    public MessageState(ZeebeDb<ZbColumnFamilies> zeebeDb, DbContext dbContext) {
        this.messageColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_KEY, dbContext, (DbKey)this.messageKey, (DbValue)this.message);
        this.messageName = new DbString();
        this.correlationKey = new DbString();
        this.nameAndCorrelationKey = new DbCompositeKey((DbKey)this.messageName, (DbKey)this.correlationKey);
        this.nameCorrelationMessageKey = new DbCompositeKey(this.nameAndCorrelationKey, (DbKey)this.messageKey);
        this.nameCorrelationMessageColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGES, dbContext, this.nameCorrelationMessageKey, (DbValue)DbNil.INSTANCE);
        this.deadline = new DbLong();
        this.deadlineMessageKey = new DbCompositeKey((DbKey)this.deadline, (DbKey)this.messageKey);
        this.deadlineColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_DEADLINES, dbContext, this.deadlineMessageKey, (DbValue)DbNil.INSTANCE);
        this.messageId = new DbString();
        this.nameCorrelationMessageIdKey = new DbCompositeKey(this.nameAndCorrelationKey, (DbKey)this.messageId);
        this.messageIdColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_IDS, dbContext, this.nameCorrelationMessageIdKey, (DbValue)DbNil.INSTANCE);
        this.workflowInstanceKey = new DbLong();
        this.messageWorkflowKey = new DbCompositeKey((DbKey)this.messageKey, (DbKey)this.workflowInstanceKey);
        this.correlatedMessageColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_CORRELATED, dbContext, this.messageWorkflowKey, (DbValue)DbNil.INSTANCE);
    }

    public void put(Message message) {
        this.messageKey.wrapLong(message.getKey());
        this.messageColumnFamily.put((DbKey)this.messageKey, (DbValue)message);
        this.messageName.wrapBuffer(message.getName());
        this.correlationKey.wrapBuffer(message.getCorrelationKey());
        this.nameCorrelationMessageColumnFamily.put(this.nameCorrelationMessageKey, (DbValue)DbNil.INSTANCE);
        this.deadline.wrapLong(message.getDeadline());
        this.deadlineColumnFamily.put(this.deadlineMessageKey, (DbValue)DbNil.INSTANCE);
        DirectBuffer messageId = message.getId();
        if (messageId.capacity() > 0) {
            this.messageId.wrapBuffer(messageId);
            this.messageIdColumnFamily.put(this.nameCorrelationMessageIdKey, (DbValue)DbNil.INSTANCE);
        }
    }

    public void putMessageCorrelation(long messageKey, long workflowInstanceKey) {
        this.messageKey.wrapLong(messageKey);
        this.workflowInstanceKey.wrapLong(workflowInstanceKey);
        this.correlatedMessageColumnFamily.put(this.messageWorkflowKey, (DbValue)DbNil.INSTANCE);
    }

    public boolean existMessageCorrelation(long messageKey, long workflowInstanceKey) {
        this.messageKey.wrapLong(messageKey);
        this.workflowInstanceKey.wrapLong(workflowInstanceKey);
        return this.correlatedMessageColumnFamily.exists(this.messageWorkflowKey);
    }

    public void removeMessageCorrelation(long messageKey, long workflowInstanceKey) {
        this.messageKey.wrapLong(messageKey);
        this.workflowInstanceKey.wrapLong(workflowInstanceKey);
        this.correlatedMessageColumnFamily.delete(this.messageWorkflowKey);
    }

    public void visitMessages(DirectBuffer name, DirectBuffer correlationKey, MessageVisitor visitor) {
        this.messageName.wrapBuffer(name);
        this.correlationKey.wrapBuffer(correlationKey);
        this.nameCorrelationMessageColumnFamily.whileEqualPrefix(this.nameAndCorrelationKey, (compositeKey, nil) -> {
            long messageKey = ((DbLong)compositeKey.getSecond()).getValue();
            Message message = this.getMessage(messageKey);
            return visitor.visit(message);
        });
    }

    public Message getMessage(long messageKey) {
        this.messageKey.wrapLong(messageKey);
        return (Message)this.messageColumnFamily.get((DbKey)this.messageKey);
    }

    public void visitMessagesWithDeadlineBefore(long timestamp, MessageVisitor visitor) {
        this.deadlineColumnFamily.whileTrue((compositeKey, zbNil) -> {
            long deadline = ((DbLong)compositeKey.getFirst()).getValue();
            if (deadline <= timestamp) {
                long messageKey = ((DbLong)compositeKey.getSecond()).getValue();
                Message message = this.getMessage(messageKey);
                return visitor.visit(message);
            }
            return false;
        });
    }

    public boolean exist(DirectBuffer name, DirectBuffer correlationKey, DirectBuffer messageId) {
        this.messageName.wrapBuffer(name);
        this.correlationKey.wrapBuffer(correlationKey);
        this.messageId.wrapBuffer(messageId);
        return this.messageIdColumnFamily.exists(this.nameCorrelationMessageIdKey);
    }

    public void remove(long key) {
        Message message = this.getMessage(key);
        if (message == null) {
            return;
        }
        this.messageKey.wrapLong(message.getKey());
        this.messageColumnFamily.delete((DbKey)this.messageKey);
        this.messageName.wrapBuffer(message.getName());
        this.correlationKey.wrapBuffer(message.getCorrelationKey());
        this.nameCorrelationMessageColumnFamily.delete(this.nameCorrelationMessageKey);
        DirectBuffer messageId = message.getId();
        if (messageId.capacity() > 0) {
            this.messageId.wrapBuffer(messageId);
            this.messageIdColumnFamily.delete(this.nameCorrelationMessageIdKey);
        }
        this.deadline.wrapLong(message.getDeadline());
        this.deadlineColumnFamily.delete(this.deadlineMessageKey);
        this.correlatedMessageColumnFamily.whileEqualPrefix((DbKey)this.messageKey, (compositeKey, zbNil) -> this.correlatedMessageColumnFamily.delete((DbKey)compositeKey));
    }

    @FunctionalInterface
    public static interface MessageVisitor {
        public boolean visit(Message var1);
    }
}

