/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.message;

import io.zeebe.db.DbValue;
import io.zeebe.db.impl.ZeebeDbConstants;
import io.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class MessageSubscription
implements DbValue {
    private final DirectBuffer messageName = new UnsafeBuffer();
    private final DirectBuffer correlationKey = new UnsafeBuffer();
    private final DirectBuffer messageVariables = new UnsafeBuffer();
    private long workflowInstanceKey;
    private long elementInstanceKey;
    private long messageKey;
    private long commandSentTime;
    private boolean closeOnCorrelate;

    public MessageSubscription() {
    }

    public MessageSubscription(long workflowInstanceKey, long elementInstanceKey, DirectBuffer messageName, DirectBuffer correlationKey, boolean closeOnCorrelate) {
        this.workflowInstanceKey = workflowInstanceKey;
        this.elementInstanceKey = elementInstanceKey;
        this.messageName.wrap(messageName);
        this.correlationKey.wrap(correlationKey);
        this.closeOnCorrelate = closeOnCorrelate;
    }

    public void setElementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
    }

    public DirectBuffer getMessageName() {
        return this.messageName;
    }

    public DirectBuffer getCorrelationKey() {
        return this.correlationKey;
    }

    public DirectBuffer getMessageVariables() {
        return this.messageVariables;
    }

    public void setMessageVariables(DirectBuffer variables) {
        this.messageVariables.wrap(variables);
    }

    public long getWorkflowInstanceKey() {
        return this.workflowInstanceKey;
    }

    public long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    public long getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(long messageKey) {
        this.messageKey = messageKey;
    }

    public long getCommandSentTime() {
        return this.commandSentTime;
    }

    public void setCommandSentTime(long commandSentTime) {
        this.commandSentTime = commandSentTime;
    }

    public boolean isCorrelating() {
        return this.commandSentTime > 0L;
    }

    public boolean shouldCloseOnCorrelate() {
        return this.closeOnCorrelate;
    }

    public void setCloseOnCorrelate(boolean closeOnCorrelate) {
        this.closeOnCorrelate = closeOnCorrelate;
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.workflowInstanceKey = buffer.getLong(offset, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        this.elementInstanceKey = buffer.getLong(offset += 8, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        this.messageKey = buffer.getLong(offset += 8, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        this.commandSentTime = buffer.getLong(offset += 8, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        this.closeOnCorrelate = buffer.getByte(offset += 8) == 1;
        ++offset;
        offset = BufferUtil.readIntoBuffer((DirectBuffer)buffer, (int)offset, (DirectBuffer)this.messageName);
        offset = BufferUtil.readIntoBuffer((DirectBuffer)buffer, (int)offset, (DirectBuffer)this.correlationKey);
        BufferUtil.readIntoBuffer((DirectBuffer)buffer, (int)offset, (DirectBuffer)this.messageVariables);
    }

    public int getLength() {
        return 45 + this.messageName.capacity() + this.correlationKey.capacity() + this.messageVariables.capacity();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        buffer.putLong(offset, this.workflowInstanceKey, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        buffer.putLong(offset += 8, this.elementInstanceKey, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        buffer.putLong(offset += 8, this.messageKey, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        buffer.putLong(offset += 8, this.commandSentTime, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        buffer.putByte(offset += 8, (byte)(this.closeOnCorrelate ? 1 : 0));
        ++offset;
        offset = BufferUtil.writeIntoBuffer((MutableDirectBuffer)buffer, (int)offset, (DirectBuffer)this.messageName);
        offset = BufferUtil.writeIntoBuffer((MutableDirectBuffer)buffer, (int)offset, (DirectBuffer)this.correlationKey);
        offset = BufferUtil.writeIntoBuffer((MutableDirectBuffer)buffer, (int)offset, (DirectBuffer)this.messageVariables);
        assert (offset == this.getLength()) : "End offset differs with getLength()";
    }
}

