/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.message;

import io.zeebe.db.ColumnFamily;
import io.zeebe.db.DbContext;
import io.zeebe.db.DbKey;
import io.zeebe.db.DbValue;
import io.zeebe.db.ZeebeDb;
import io.zeebe.db.impl.DbCompositeKey;
import io.zeebe.db.impl.DbLong;
import io.zeebe.db.impl.DbNil;
import io.zeebe.db.impl.DbString;
import io.zeebe.engine.state.ZbColumnFamilies;
import io.zeebe.engine.state.message.MessageSubscription;
import org.agrona.DirectBuffer;

public class MessageSubscriptionState {
    private final DbContext dbContext;
    private final DbLong elementInstanceKey;
    private final DbString messageName;
    private final MessageSubscription messageSubscription;
    private final DbCompositeKey<DbLong, DbString> elementKeyAndMessageName;
    private final ColumnFamily<DbCompositeKey<DbLong, DbString>, MessageSubscription> subscriptionColumnFamily;
    private final DbLong sentTime;
    private final DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>> sentTimeCompositeKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>>, DbNil> sentTimeColumnFamily;
    private final DbString correlationKey;
    private final DbCompositeKey<DbString, DbString> nameAndCorrelationKey;
    private final DbCompositeKey<DbCompositeKey<DbString, DbString>, DbLong> nameCorrelationAndElementInstanceKey;
    private final ColumnFamily<DbCompositeKey<DbCompositeKey<DbString, DbString>, DbLong>, DbNil> messageNameAndCorrelationKeyColumnFamily;

    public MessageSubscriptionState(ZeebeDb<ZbColumnFamilies> zeebeDb, DbContext dbContext) {
        this.dbContext = dbContext;
        this.elementInstanceKey = new DbLong();
        this.messageName = new DbString();
        this.messageSubscription = new MessageSubscription();
        this.elementKeyAndMessageName = new DbCompositeKey((DbKey)this.elementInstanceKey, (DbKey)this.messageName);
        this.subscriptionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_SUBSCRIPTION_BY_KEY, dbContext, this.elementKeyAndMessageName, (DbValue)this.messageSubscription);
        this.sentTime = new DbLong();
        this.sentTimeCompositeKey = new DbCompositeKey((DbKey)this.sentTime, this.elementKeyAndMessageName);
        this.sentTimeColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_SUBSCRIPTION_BY_SENT_TIME, dbContext, this.sentTimeCompositeKey, (DbValue)DbNil.INSTANCE);
        this.correlationKey = new DbString();
        this.nameAndCorrelationKey = new DbCompositeKey((DbKey)this.messageName, (DbKey)this.correlationKey);
        this.nameCorrelationAndElementInstanceKey = new DbCompositeKey(this.nameAndCorrelationKey, (DbKey)this.elementInstanceKey);
        this.messageNameAndCorrelationKeyColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.MESSAGE_SUBSCRIPTION_BY_NAME_AND_CORRELATION_KEY, dbContext, this.nameCorrelationAndElementInstanceKey, (DbValue)DbNil.INSTANCE);
    }

    public MessageSubscription get(long elementInstanceKey, DirectBuffer messageName) {
        this.messageName.wrapBuffer(messageName);
        this.elementInstanceKey.wrapLong(elementInstanceKey);
        return (MessageSubscription)this.subscriptionColumnFamily.get(this.elementKeyAndMessageName);
    }

    public void put(MessageSubscription subscription) {
        this.elementInstanceKey.wrapLong(subscription.getElementInstanceKey());
        this.messageName.wrapBuffer(subscription.getMessageName());
        this.subscriptionColumnFamily.put(this.elementKeyAndMessageName, (DbValue)subscription);
        this.correlationKey.wrapBuffer(subscription.getCorrelationKey());
        this.messageNameAndCorrelationKeyColumnFamily.put(this.nameCorrelationAndElementInstanceKey, (DbValue)DbNil.INSTANCE);
    }

    public void visitSubscriptions(DirectBuffer messageName, DirectBuffer correlationKey, MessageSubscriptionVisitor visitor) {
        this.messageName.wrapBuffer(messageName);
        this.correlationKey.wrapBuffer(correlationKey);
        this.messageNameAndCorrelationKeyColumnFamily.whileEqualPrefix(this.nameAndCorrelationKey, (compositeKey, nil) -> this.visitMessageSubscription(this.elementKeyAndMessageName, visitor));
    }

    private Boolean visitMessageSubscription(DbCompositeKey<DbLong, DbString> elementKeyAndMessageName, MessageSubscriptionVisitor visitor) {
        MessageSubscription messageSubscription = (MessageSubscription)this.subscriptionColumnFamily.get(elementKeyAndMessageName);
        if (messageSubscription == null) {
            throw new IllegalStateException(String.format("Expected to find subscription with key %d and %s, but no subscription found", ((DbLong)elementKeyAndMessageName.getFirst()).getValue(), elementKeyAndMessageName.getSecond()));
        }
        return visitor.visit(messageSubscription);
    }

    public void updateToCorrelatingState(MessageSubscription subscription, DirectBuffer messageVariables, long sentTime, long messageKey) {
        subscription.setMessageVariables(messageVariables);
        subscription.setMessageKey(messageKey);
        this.updateSentTime(subscription, sentTime);
    }

    public void resetSentTime(MessageSubscription subscription) {
        this.updateSentTime(subscription, 0L);
    }

    public void updateSentTimeInTransaction(MessageSubscription subscription, long sentTime) {
        this.dbContext.runInTransaction(() -> this.updateSentTime(subscription, sentTime));
    }

    public void updateSentTime(MessageSubscription subscription, long sentTime) {
        this.elementInstanceKey.wrapLong(subscription.getElementInstanceKey());
        this.messageName.wrapBuffer(subscription.getMessageName());
        this.removeSubscriptionFromSentTimeColumnFamily(subscription);
        subscription.setCommandSentTime(sentTime);
        this.subscriptionColumnFamily.put(this.elementKeyAndMessageName, (DbValue)subscription);
        if (sentTime > 0L) {
            this.sentTime.wrapLong(subscription.getCommandSentTime());
            this.sentTimeColumnFamily.put(this.sentTimeCompositeKey, (DbValue)DbNil.INSTANCE);
        }
    }

    public void visitSubscriptionBefore(long deadline, MessageSubscriptionVisitor visitor) {
        this.sentTimeColumnFamily.whileTrue((compositeKey, nil) -> {
            long sentTime = ((DbLong)compositeKey.getFirst()).getValue();
            if (sentTime < deadline) {
                return this.visitMessageSubscription((DbCompositeKey<DbLong, DbString>)((DbCompositeKey)compositeKey.getSecond()), visitor);
            }
            return false;
        });
    }

    public boolean existSubscriptionForElementInstance(long elementInstanceKey, DirectBuffer messageName) {
        this.elementInstanceKey.wrapLong(elementInstanceKey);
        this.messageName.wrapBuffer(messageName);
        return this.subscriptionColumnFamily.exists(this.elementKeyAndMessageName);
    }

    public boolean remove(long elementInstanceKey, DirectBuffer messageName) {
        boolean found;
        this.elementInstanceKey.wrapLong(elementInstanceKey);
        this.messageName.wrapBuffer(messageName);
        MessageSubscription messageSubscription = (MessageSubscription)this.subscriptionColumnFamily.get(this.elementKeyAndMessageName);
        boolean bl = found = messageSubscription != null;
        if (found) {
            this.remove(messageSubscription);
        }
        return found;
    }

    public void remove(MessageSubscription subscription) {
        this.subscriptionColumnFamily.delete(this.elementKeyAndMessageName);
        this.messageName.wrapBuffer(subscription.getMessageName());
        this.correlationKey.wrapBuffer(subscription.getCorrelationKey());
        this.messageNameAndCorrelationKeyColumnFamily.delete(this.nameCorrelationAndElementInstanceKey);
        this.removeSubscriptionFromSentTimeColumnFamily(subscription);
    }

    private void removeSubscriptionFromSentTimeColumnFamily(MessageSubscription subscription) {
        if (subscription.getCommandSentTime() > 0L) {
            this.sentTime.wrapLong(subscription.getCommandSentTime());
            this.sentTimeColumnFamily.delete(this.sentTimeCompositeKey);
        }
    }

    @FunctionalInterface
    public static interface MessageSubscriptionVisitor {
        public boolean visit(MessageSubscription var1);
    }
}

