/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.message;

import io.zeebe.db.DbValue;
import io.zeebe.db.impl.ZeebeDbConstants;
import io.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class WorkflowInstanceSubscription
implements DbValue {
    private static final int STATE_OPENING = 0;
    private static final int STATE_OPENED = 1;
    private static final int STATE_CLOSING = 2;
    private final DirectBuffer messageName = new UnsafeBuffer();
    private final DirectBuffer correlationKey = new UnsafeBuffer();
    private final DirectBuffer handlerNodeId = new UnsafeBuffer();
    private long workflowInstanceKey;
    private long elementInstanceKey;
    private int subscriptionPartitionId;
    private long commandSentTime;
    private boolean closeOnCorrelate = true;
    private int state = 0;

    public WorkflowInstanceSubscription() {
    }

    public WorkflowInstanceSubscription(long workflowInstanceKey, long elementInstanceKey) {
        this.workflowInstanceKey = workflowInstanceKey;
        this.elementInstanceKey = elementInstanceKey;
    }

    public WorkflowInstanceSubscription(long workflowInstanceKey, long elementInstanceKey, DirectBuffer handlerNodeId, DirectBuffer messageName, DirectBuffer correlationKey, long commandSentTime, boolean closeOnCorrelate) {
        this(workflowInstanceKey, elementInstanceKey);
        this.handlerNodeId.wrap(handlerNodeId);
        this.commandSentTime = commandSentTime;
        this.messageName.wrap(messageName);
        this.correlationKey.wrap(correlationKey);
        this.closeOnCorrelate = closeOnCorrelate;
    }

    public DirectBuffer getMessageName() {
        return this.messageName;
    }

    public void setMessageName(DirectBuffer messageName) {
        this.messageName.wrap(messageName);
    }

    public DirectBuffer getCorrelationKey() {
        return this.correlationKey;
    }

    public void setCorrelationKey(DirectBuffer correlationKey) {
        this.correlationKey.wrap(correlationKey);
    }

    public DirectBuffer getHandlerNodeId() {
        return this.handlerNodeId;
    }

    public void setHandlerNodeId(DirectBuffer handlerNodeId) {
        this.handlerNodeId.wrap(handlerNodeId);
    }

    public long getWorkflowInstanceKey() {
        return this.workflowInstanceKey;
    }

    public void setWorkflowInstanceKey(long workflowInstanceKey) {
        this.workflowInstanceKey = workflowInstanceKey;
    }

    public void setElementInstanceKey(long elementInstanceKey) {
        this.elementInstanceKey = elementInstanceKey;
    }

    public long getElementInstanceKey() {
        return this.elementInstanceKey;
    }

    public long getCommandSentTime() {
        return this.commandSentTime;
    }

    public void setCommandSentTime(long commandSentTime) {
        this.commandSentTime = commandSentTime;
    }

    public int getSubscriptionPartitionId() {
        return this.subscriptionPartitionId;
    }

    public void setSubscriptionPartitionId(int subscriptionPartitionId) {
        this.subscriptionPartitionId = subscriptionPartitionId;
    }

    public boolean shouldCloseOnCorrelate() {
        return this.closeOnCorrelate;
    }

    public void setCloseOnCorrelate(boolean closeOnCorrelate) {
        this.closeOnCorrelate = closeOnCorrelate;
    }

    public boolean isOpening() {
        return this.state == 0;
    }

    public boolean isClosing() {
        return this.state == 2;
    }

    public void setOpened() {
        this.state = 1;
    }

    public void setClosing() {
        this.state = 2;
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        int startOffset = offset;
        this.workflowInstanceKey = buffer.getLong(offset, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        this.elementInstanceKey = buffer.getLong(offset += 8, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        this.subscriptionPartitionId = buffer.getInt(offset += 8, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        this.commandSentTime = buffer.getLong(offset += 4, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        this.state = buffer.getInt(offset += 8, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        this.closeOnCorrelate = buffer.getByte(offset += 4) == 1;
        ++offset;
        offset = BufferUtil.readIntoBuffer((DirectBuffer)buffer, (int)offset, (DirectBuffer)this.messageName);
        offset = BufferUtil.readIntoBuffer((DirectBuffer)buffer, (int)offset, (DirectBuffer)this.correlationKey);
        offset = BufferUtil.readIntoBuffer((DirectBuffer)buffer, (int)offset, (DirectBuffer)this.handlerNodeId);
        assert (offset - startOffset == length) : "End offset differs from length";
    }

    public int getLength() {
        return 45 + this.messageName.capacity() + this.correlationKey.capacity() + this.handlerNodeId.capacity();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        buffer.putLong(offset, this.workflowInstanceKey, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        buffer.putLong(offset += 8, this.elementInstanceKey, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        buffer.putInt(offset += 8, this.subscriptionPartitionId, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        buffer.putLong(offset += 4, this.commandSentTime, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        buffer.putInt(offset += 8, this.state, ZeebeDbConstants.ZB_DB_BYTE_ORDER);
        buffer.putByte(offset += 4, (byte)(this.closeOnCorrelate ? 1 : 0));
        ++offset;
        offset = BufferUtil.writeIntoBuffer((MutableDirectBuffer)buffer, (int)offset, (DirectBuffer)this.messageName);
        offset = BufferUtil.writeIntoBuffer((MutableDirectBuffer)buffer, (int)offset, (DirectBuffer)this.correlationKey);
        offset = BufferUtil.writeIntoBuffer((MutableDirectBuffer)buffer, (int)offset, (DirectBuffer)this.handlerNodeId);
        assert (offset == this.getLength()) : "End offset differs with getLength()";
    }

    public String toString() {
        return "WorkflowInstanceSubscription{elementInstanceKey=" + this.elementInstanceKey + ", messageName=" + BufferUtil.bufferAsString((DirectBuffer)this.messageName) + ", correlationKey=" + BufferUtil.bufferAsString((DirectBuffer)this.correlationKey) + ", workflowInstanceKey=" + this.workflowInstanceKey + ", subscriptionPartitionId=" + this.subscriptionPartitionId + ", commandSentTime=" + this.commandSentTime + ", state=" + this.state + '}';
    }
}

