/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.engine.state.message;

import io.zeebe.db.ColumnFamily;
import io.zeebe.db.DbContext;
import io.zeebe.db.DbKey;
import io.zeebe.db.DbValue;
import io.zeebe.db.ZeebeDb;
import io.zeebe.db.impl.DbCompositeKey;
import io.zeebe.db.impl.DbLong;
import io.zeebe.db.impl.DbNil;
import io.zeebe.db.impl.DbString;
import io.zeebe.engine.state.ZbColumnFamilies;
import io.zeebe.engine.state.message.WorkflowInstanceSubscription;
import org.agrona.DirectBuffer;

public class WorkflowInstanceSubscriptionState {
    private final DbContext dbContext;
    private final DbLong elementInstanceKey;
    private final DbString messageName;
    private final DbCompositeKey<DbLong, DbString> elementKeyAndMessageName;
    private final WorkflowInstanceSubscription workflowInstanceSubscription;
    private final ColumnFamily<DbCompositeKey<DbLong, DbString>, WorkflowInstanceSubscription> subscriptionColumnFamily;
    private final DbLong sentTime;
    private final DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>> sentTimeCompositeKey;
    private final ColumnFamily<DbCompositeKey<DbLong, DbCompositeKey<DbLong, DbString>>, DbNil> sentTimeColumnFamily;

    public WorkflowInstanceSubscriptionState(ZeebeDb<ZbColumnFamilies> zeebeDb, DbContext dbContext) {
        this.dbContext = dbContext;
        this.elementInstanceKey = new DbLong();
        this.messageName = new DbString();
        this.elementKeyAndMessageName = new DbCompositeKey((DbKey)this.elementInstanceKey, (DbKey)this.messageName);
        this.workflowInstanceSubscription = new WorkflowInstanceSubscription();
        this.subscriptionColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.WORKFLOW_SUBSCRIPTION_BY_KEY, dbContext, this.elementKeyAndMessageName, (DbValue)this.workflowInstanceSubscription);
        this.sentTime = new DbLong();
        this.sentTimeCompositeKey = new DbCompositeKey((DbKey)this.sentTime, this.elementKeyAndMessageName);
        this.sentTimeColumnFamily = zeebeDb.createColumnFamily((Enum)ZbColumnFamilies.WORKFLOW_SUBSCRIPTION_BY_SENT_TIME, dbContext, this.sentTimeCompositeKey, (DbValue)DbNil.INSTANCE);
    }

    public void put(WorkflowInstanceSubscription subscription) {
        this.wrapSubscriptionKeys(subscription.getElementInstanceKey(), subscription.getMessageName());
        this.subscriptionColumnFamily.put(this.elementKeyAndMessageName, (DbValue)subscription);
        this.sentTime.wrapLong(subscription.getCommandSentTime());
        this.sentTimeColumnFamily.put(this.sentTimeCompositeKey, (DbValue)DbNil.INSTANCE);
    }

    public WorkflowInstanceSubscription getSubscription(long elementInstanceKey, DirectBuffer messageName) {
        this.wrapSubscriptionKeys(elementInstanceKey, messageName);
        return (WorkflowInstanceSubscription)this.subscriptionColumnFamily.get(this.elementKeyAndMessageName);
    }

    public void visitElementSubscriptions(long elementInstanceKey, WorkflowInstanceSubscriptionVisitor visitor) {
        this.elementInstanceKey.wrapLong(elementInstanceKey);
        this.subscriptionColumnFamily.whileEqualPrefix((DbKey)this.elementInstanceKey, (compositeKey, subscription) -> visitor.visit((WorkflowInstanceSubscription)subscription));
    }

    public void visitSubscriptionBefore(long deadline, WorkflowInstanceSubscriptionVisitor visitor) {
        this.sentTimeColumnFamily.whileTrue((compositeKey, nil) -> {
            long sentTime = ((DbLong)compositeKey.getFirst()).getValue();
            if (sentTime < deadline) {
                WorkflowInstanceSubscription workflowInstanceSubscription = (WorkflowInstanceSubscription)this.subscriptionColumnFamily.get(compositeKey.getSecond());
                return visitor.visit(workflowInstanceSubscription);
            }
            return false;
        });
    }

    public void updateToOpenedState(WorkflowInstanceSubscription subscription, int subscriptionPartitionId) {
        subscription.setOpened();
        subscription.setSubscriptionPartitionId(subscriptionPartitionId);
        this.updateSentTime(subscription, 0L);
    }

    public void updateToClosingState(WorkflowInstanceSubscription subscription, long sentTime) {
        subscription.setClosing();
        this.updateSentTime(subscription, sentTime);
    }

    public void updateSentTimeInTransaction(WorkflowInstanceSubscription subscription, long sentTime) {
        this.dbContext.runInTransaction(() -> this.updateSentTime(subscription, sentTime));
    }

    public void updateSentTime(WorkflowInstanceSubscription subscription, long sentTime) {
        this.wrapSubscriptionKeys(subscription.getElementInstanceKey(), subscription.getMessageName());
        if (subscription.getCommandSentTime() > 0L) {
            this.sentTime.wrapLong(subscription.getCommandSentTime());
            this.sentTimeColumnFamily.delete(this.sentTimeCompositeKey);
        }
        subscription.setCommandSentTime(sentTime);
        this.subscriptionColumnFamily.put(this.elementKeyAndMessageName, (DbValue)subscription);
        if (sentTime > 0L) {
            this.sentTime.wrapLong(sentTime);
            this.sentTimeColumnFamily.put(this.sentTimeCompositeKey, (DbValue)DbNil.INSTANCE);
        }
    }

    public boolean existSubscriptionForElementInstance(long elementInstanceKey, DirectBuffer messageName) {
        this.wrapSubscriptionKeys(elementInstanceKey, messageName);
        return this.subscriptionColumnFamily.exists(this.elementKeyAndMessageName);
    }

    public boolean remove(long elementInstanceKey, DirectBuffer messageName) {
        boolean found;
        WorkflowInstanceSubscription subscription = this.getSubscription(elementInstanceKey, messageName);
        boolean bl = found = subscription != null;
        if (found) {
            this.remove(subscription);
        }
        return found;
    }

    public void remove(WorkflowInstanceSubscription subscription) {
        this.wrapSubscriptionKeys(subscription.getElementInstanceKey(), subscription.getMessageName());
        this.subscriptionColumnFamily.delete(this.elementKeyAndMessageName);
        this.sentTime.wrapLong(subscription.getCommandSentTime());
        this.sentTimeColumnFamily.delete(this.sentTimeCompositeKey);
    }

    private void wrapSubscriptionKeys(long elementInstanceKey, DirectBuffer messageName) {
        this.elementInstanceKey.wrapLong(elementInstanceKey);
        this.messageName.wrapBuffer(messageName);
    }

    @FunctionalInterface
    public static interface WorkflowInstanceSubscriptionVisitor {
        public boolean visit(WorkflowInstanceSubscription var1);
    }
}

