/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway;

import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import io.zeebe.gateway.Loggers;
import io.zeebe.gateway.RequestMapper;
import io.zeebe.gateway.ResponseMapper;
import io.zeebe.gateway.cmd.BrokerErrorException;
import io.zeebe.gateway.cmd.BrokerRejectionException;
import io.zeebe.gateway.cmd.ClientOutOfMemoryException;
import io.zeebe.gateway.cmd.GrpcStatusException;
import io.zeebe.gateway.cmd.GrpcStatusExceptionImpl;
import io.zeebe.gateway.impl.broker.BrokerClient;
import io.zeebe.gateway.impl.broker.cluster.BrokerClusterState;
import io.zeebe.gateway.impl.broker.cluster.BrokerTopologyManager;
import io.zeebe.gateway.impl.broker.request.BrokerRequest;
import io.zeebe.gateway.impl.broker.response.BrokerError;
import io.zeebe.gateway.impl.broker.response.BrokerRejection;
import io.zeebe.gateway.impl.job.ActivateJobsHandler;
import io.zeebe.gateway.protocol.GatewayGrpc;
import io.zeebe.gateway.protocol.GatewayOuterClass;
import io.zeebe.msgpack.MsgpackPropertyException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;

public class EndpointManager
extends GatewayGrpc.GatewayImplBase {
    private final BrokerClient brokerClient;
    private final BrokerTopologyManager topologyManager;
    private final ActivateJobsHandler activateJobsHandler;

    public EndpointManager(BrokerClient brokerClient) {
        this.brokerClient = brokerClient;
        this.topologyManager = brokerClient.getTopologyManager();
        this.activateJobsHandler = new ActivateJobsHandler(brokerClient);
    }

    public void topology(GatewayOuterClass.TopologyRequest request, StreamObserver<GatewayOuterClass.TopologyResponse> responseObserver) {
        GatewayOuterClass.TopologyResponse.Builder topologyResponseBuilder = GatewayOuterClass.TopologyResponse.newBuilder();
        BrokerClusterState topology = this.topologyManager.getTopology();
        if (topology != null) {
            topologyResponseBuilder.setClusterSize(topology.getClusterSize()).setPartitionsCount(topology.getPartitionsCount()).setReplicationFactor(topology.getReplicationFactor());
            ArrayList brokers = new ArrayList();
            topology.getBrokers().forEach(brokerId -> {
                GatewayOuterClass.BrokerInfo.Builder brokerInfo = GatewayOuterClass.BrokerInfo.newBuilder();
                this.addBrokerInfo(brokerInfo, (Integer)brokerId, topology);
                this.addPartitionInfoToBrokerInfo(brokerInfo, (Integer)brokerId, topology);
                brokers.add(brokerInfo.build());
            });
            topologyResponseBuilder.addAllBrokers(brokers);
            GatewayOuterClass.TopologyResponse response = topologyResponseBuilder.build();
            responseObserver.onNext((Object)response);
            responseObserver.onCompleted();
        } else {
            StatusRuntimeException error = Status.UNAVAILABLE.augmentDescription("No brokers available").asRuntimeException();
            responseObserver.onError((Throwable)error);
        }
    }

    private void addBrokerInfo(GatewayOuterClass.BrokerInfo.Builder brokerInfo, Integer brokerId, BrokerClusterState topology) {
        String[] addressParts = topology.getBrokerAddress(brokerId).split(":");
        brokerInfo.setNodeId(brokerId.intValue()).setHost(addressParts[0]).setPort(Integer.parseInt(addressParts[1]));
    }

    private void addPartitionInfoToBrokerInfo(GatewayOuterClass.BrokerInfo.Builder brokerInfo, Integer brokerId, BrokerClusterState topology) {
        topology.getPartitions().forEach(partitionId -> {
            GatewayOuterClass.Partition.Builder partitionBuilder = GatewayOuterClass.Partition.newBuilder();
            partitionBuilder.setPartitionId(partitionId.intValue());
            if (topology.getLeaderForPartition((int)partitionId) == brokerId.intValue()) {
                partitionBuilder.setRole(GatewayOuterClass.Partition.PartitionBrokerRole.LEADER);
            } else {
                List<Integer> followersForPartition = topology.getFollowersForPartition((int)partitionId);
                if (followersForPartition != null && followersForPartition.contains(brokerId)) {
                    partitionBuilder.setRole(GatewayOuterClass.Partition.PartitionBrokerRole.FOLLOWER);
                } else {
                    return;
                }
            }
            brokerInfo.addPartitions(partitionBuilder);
        });
    }

    public void deployWorkflow(GatewayOuterClass.DeployWorkflowRequest request, StreamObserver<GatewayOuterClass.DeployWorkflowResponse> responseObserver) {
        this.sendRequest(request, RequestMapper::toDeployWorkflowRequest, ResponseMapper::toDeployWorkflowResponse, responseObserver);
    }

    public void publishMessage(GatewayOuterClass.PublishMessageRequest request, StreamObserver<GatewayOuterClass.PublishMessageResponse> responseObserver) {
        this.sendRequest(request, RequestMapper::toPublishMessageRequest, ResponseMapper::toPublishMessageResponse, responseObserver);
    }

    public void updateJobRetries(GatewayOuterClass.UpdateJobRetriesRequest request, StreamObserver<GatewayOuterClass.UpdateJobRetriesResponse> responseObserver) {
        this.sendRequest(request, RequestMapper::toUpdateJobRetriesRequest, ResponseMapper::toUpdateJobRetriesResponse, responseObserver);
    }

    public void createWorkflowInstance(GatewayOuterClass.CreateWorkflowInstanceRequest request, StreamObserver<GatewayOuterClass.CreateWorkflowInstanceResponse> responseObserver) {
        this.sendRequest(request, RequestMapper::toCreateWorkflowInstanceRequest, ResponseMapper::toCreateWorkflowInstanceResponse, responseObserver);
    }

    public void cancelWorkflowInstance(GatewayOuterClass.CancelWorkflowInstanceRequest request, StreamObserver<GatewayOuterClass.CancelWorkflowInstanceResponse> responseObserver) {
        this.sendRequest(request, RequestMapper::toCancelWorkflowInstanceRequest, ResponseMapper::toCancelWorkflowInstanceResponse, responseObserver);
    }

    public void setVariables(GatewayOuterClass.SetVariablesRequest request, StreamObserver<GatewayOuterClass.SetVariablesResponse> responseObserver) {
        this.sendRequest(request, RequestMapper::toSetVariablesRequest, ResponseMapper::toSetVariablesResponse, responseObserver);
    }

    public void failJob(GatewayOuterClass.FailJobRequest request, StreamObserver<GatewayOuterClass.FailJobResponse> responseObserver) {
        this.sendRequest(request, RequestMapper::toFailJobRequest, ResponseMapper::toFailJobResponse, responseObserver);
    }

    public void completeJob(GatewayOuterClass.CompleteJobRequest request, StreamObserver<GatewayOuterClass.CompleteJobResponse> responseObserver) {
        this.sendRequest(request, RequestMapper::toCompleteJobRequest, ResponseMapper::toCompleteJobResponse, responseObserver);
    }

    public void activateJobs(GatewayOuterClass.ActivateJobsRequest request, StreamObserver<GatewayOuterClass.ActivateJobsResponse> responseObserver) {
        BrokerClusterState topology = this.topologyManager.getTopology();
        this.activateJobsHandler.activateJobs(topology.getPartitionsCount(), request, responseObserver);
    }

    public void resolveIncident(GatewayOuterClass.ResolveIncidentRequest request, StreamObserver<GatewayOuterClass.ResolveIncidentResponse> responseObserver) {
        this.sendRequest(request, RequestMapper::toResolveIncidentRequest, ResponseMapper::toResolveIncidentResponse, responseObserver);
    }

    private <GrpcRequestT, BrokerResponseT, GrpcResponseT> void sendRequest(GrpcRequestT grpcRequest, Function<GrpcRequestT, BrokerRequest<BrokerResponseT>> requestMapper, ResponseMapper.BrokerResponseMapper<BrokerResponseT, GrpcResponseT> responseMapper, StreamObserver<GrpcResponseT> streamObserver) {
        BrokerRequest<BrokerResponseT> brokerRequest;
        try {
            brokerRequest = requestMapper.apply(grpcRequest);
        }
        catch (MsgpackPropertyException e) {
            streamObserver.onError((Throwable)this.convertThrowable(new GrpcStatusExceptionImpl(e.getMessage(), Status.INVALID_ARGUMENT, e)));
            return;
        }
        catch (Exception e) {
            streamObserver.onError((Throwable)this.convertThrowable(e));
            return;
        }
        this.brokerClient.sendRequest(brokerRequest, (key, response) -> {
            Object grpcResponse = responseMapper.apply(key, response);
            streamObserver.onNext(grpcResponse);
            streamObserver.onCompleted();
        }, error -> streamObserver.onError((Throwable)this.convertThrowable((Throwable)error)));
    }

    private StatusRuntimeException convertThrowable(Throwable cause) {
        Status status = Status.INTERNAL;
        if (cause instanceof ExecutionException) {
            return this.convertThrowable(cause.getCause());
        }
        status = cause instanceof BrokerErrorException ? this.mapBrokerErrorToStatus(((BrokerErrorException)cause).getError()) : (cause instanceof BrokerRejectionException ? this.mapRejectionToStatus(((BrokerRejectionException)cause).getRejection()) : (cause instanceof ClientOutOfMemoryException ? Status.UNAVAILABLE.augmentDescription(cause.getMessage()) : (cause instanceof GrpcStatusException ? ((GrpcStatusException)((Object)cause)).getGrpcStatus() : status.augmentDescription("Unexpected error occurred during the request processing"))));
        StatusRuntimeException convertedThrowable = status.withCause(cause).asRuntimeException();
        Loggers.GATEWAY_LOGGER.error("Error handling gRPC request", (Throwable)convertedThrowable);
        return convertedThrowable;
    }

    private Status mapBrokerErrorToStatus(BrokerError error) {
        switch (error.getCode()) {
            case WORKFLOW_NOT_FOUND: {
                return Status.NOT_FOUND.augmentDescription(error.getMessage());
            }
        }
        return Status.INTERNAL.augmentDescription(String.format("Unexpected error occurred between gateway and broker (code: %s)", error.getCode()));
    }

    private Status mapRejectionToStatus(BrokerRejection rejection) {
        Status status;
        String description = String.format("Command rejected with code '%s': %s", rejection.getIntent(), rejection.getReason());
        switch (rejection.getType()) {
            case INVALID_ARGUMENT: {
                status = Status.INVALID_ARGUMENT;
                break;
            }
            case NOT_FOUND: {
                status = Status.NOT_FOUND;
                break;
            }
            case ALREADY_EXISTS: {
                status = Status.ALREADY_EXISTS;
                break;
            }
            case INVALID_STATE: {
                status = Status.FAILED_PRECONDITION;
                break;
            }
            default: {
                status = Status.UNKNOWN;
            }
        }
        return status.augmentDescription(description);
    }
}

