/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway;

import io.atomix.cluster.AtomixCluster;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.netty.NettyServerBuilder;
import io.zeebe.gateway.EndpointManager;
import io.zeebe.gateway.Loggers;
import io.zeebe.gateway.impl.broker.BrokerClient;
import io.zeebe.gateway.impl.broker.BrokerClientImpl;
import io.zeebe.gateway.impl.configuration.GatewayCfg;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.function.Function;
import org.slf4j.Logger;

public class Gateway {
    public static final String VERSION;
    private static final Logger LOG;
    private static final Function<GatewayCfg, ServerBuilder> DEFAULT_SERVER_BUILDER_FACTORY;
    private final Function<GatewayCfg, ServerBuilder> serverBuilderFactory;
    private final Function<GatewayCfg, BrokerClient> brokerClientFactory;
    private final GatewayCfg gatewayCfg;
    private Server server;
    private BrokerClient brokerClient;
    private EndpointManager endpointManager;

    public Gateway(GatewayCfg gatewayCfg, AtomixCluster atomixCluster) {
        this(gatewayCfg, cfg -> new BrokerClientImpl((GatewayCfg)cfg, atomixCluster), DEFAULT_SERVER_BUILDER_FACTORY);
    }

    public Gateway(GatewayCfg gatewayCfg, Function<GatewayCfg, BrokerClient> brokerClientFactory) {
        this(gatewayCfg, brokerClientFactory, DEFAULT_SERVER_BUILDER_FACTORY);
    }

    public Gateway(GatewayCfg gatewayCfg, Function<GatewayCfg, BrokerClient> brokerClientFactory, Function<GatewayCfg, ServerBuilder> serverBuilderFactory) {
        this.gatewayCfg = gatewayCfg;
        this.brokerClientFactory = brokerClientFactory;
        this.serverBuilderFactory = serverBuilderFactory;
    }

    public GatewayCfg getGatewayCfg() {
        return this.gatewayCfg;
    }

    public BrokerClient getBrokerClient() {
        return this.brokerClient;
    }

    public void start() throws IOException {
        LOG.info("Version: {}", (Object)VERSION);
        LOG.info("Starting gateway with configuration {}", (Object)this.gatewayCfg.toJson());
        this.brokerClient = this.buildBrokerClient();
        this.endpointManager = new EndpointManager(this.brokerClient);
        this.server = this.serverBuilderFactory.apply(this.gatewayCfg).addService((BindableService)this.endpointManager).build();
        this.server.start();
    }

    protected BrokerClient buildBrokerClient() {
        return this.brokerClientFactory.apply(this.gatewayCfg);
    }

    public void listenAndServe() throws InterruptedException, IOException {
        this.start();
        this.server.awaitTermination();
    }

    public void stop() {
        if (this.server != null && !this.server.isShutdown()) {
            this.server.shutdown();
            try {
                this.server.awaitTermination();
            }
            catch (InterruptedException e) {
                LOG.error("Failed to await termination of gateway", (Throwable)e);
            }
            finally {
                this.server = null;
            }
        }
        if (this.brokerClient != null) {
            this.brokerClient.close();
            this.brokerClient = null;
        }
    }

    static {
        LOG = Loggers.GATEWAY_LOGGER;
        DEFAULT_SERVER_BUILDER_FACTORY = cfg -> NettyServerBuilder.forAddress((SocketAddress)new InetSocketAddress(cfg.getNetwork().getHost(), cfg.getNetwork().getPort()));
        String version = Gateway.class.getPackage().getImplementationVersion();
        VERSION = version != null ? version : "development";
    }
}

