/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway;

import io.zeebe.gateway.protocol.GatewayOuterClass;
import io.zeebe.msgpack.value.LongValue;
import io.zeebe.protocol.impl.encoding.MsgPackConverter;
import io.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.zeebe.protocol.impl.record.value.incident.IncidentRecord;
import io.zeebe.protocol.impl.record.value.job.JobBatchRecord;
import io.zeebe.protocol.impl.record.value.job.JobHeaders;
import io.zeebe.protocol.impl.record.value.job.JobRecord;
import io.zeebe.protocol.impl.record.value.variable.VariableDocumentRecord;
import io.zeebe.protocol.impl.record.value.workflowinstance.WorkflowInstanceCreationRecord;
import io.zeebe.protocol.impl.record.value.workflowinstance.WorkflowInstanceRecord;
import io.zeebe.util.buffer.BufferUtil;
import java.util.Iterator;
import org.agrona.DirectBuffer;

public class ResponseMapper {
    public static GatewayOuterClass.DeployWorkflowResponse toDeployWorkflowResponse(long key, DeploymentRecord brokerResponse) {
        GatewayOuterClass.DeployWorkflowResponse.Builder responseBuilder = GatewayOuterClass.DeployWorkflowResponse.newBuilder().setKey(key);
        brokerResponse.workflows().forEach(workflow -> responseBuilder.addWorkflowsBuilder().setBpmnProcessId(BufferUtil.bufferAsString((DirectBuffer)workflow.getBpmnProcessIdBuffer())).setVersion(workflow.getVersion()).setWorkflowKey(workflow.getKey()).setResourceName(BufferUtil.bufferAsString((DirectBuffer)workflow.getResourceNameBuffer())));
        return responseBuilder.build();
    }

    public static GatewayOuterClass.PublishMessageResponse toPublishMessageResponse(long key, Object brokerResponse) {
        return GatewayOuterClass.PublishMessageResponse.getDefaultInstance();
    }

    public static GatewayOuterClass.UpdateJobRetriesResponse toUpdateJobRetriesResponse(long key, JobRecord brokerResponse) {
        return GatewayOuterClass.UpdateJobRetriesResponse.getDefaultInstance();
    }

    public static GatewayOuterClass.FailJobResponse toFailJobResponse(long key, JobRecord brokerResponse) {
        return GatewayOuterClass.FailJobResponse.getDefaultInstance();
    }

    public static GatewayOuterClass.CompleteJobResponse toCompleteJobResponse(long key, JobRecord brokerResponse) {
        return GatewayOuterClass.CompleteJobResponse.getDefaultInstance();
    }

    public static GatewayOuterClass.CreateWorkflowInstanceResponse toCreateWorkflowInstanceResponse(long key, WorkflowInstanceCreationRecord brokerResponse) {
        return GatewayOuterClass.CreateWorkflowInstanceResponse.newBuilder().setWorkflowKey(brokerResponse.getKey()).setBpmnProcessId(BufferUtil.bufferAsString((DirectBuffer)brokerResponse.getBpmnProcessIdBuffer())).setVersion(brokerResponse.getVersion()).setWorkflowInstanceKey(brokerResponse.getInstanceKey()).build();
    }

    public static GatewayOuterClass.CancelWorkflowInstanceResponse toCancelWorkflowInstanceResponse(long key, WorkflowInstanceRecord brokerResponse) {
        return GatewayOuterClass.CancelWorkflowInstanceResponse.getDefaultInstance();
    }

    public static GatewayOuterClass.SetVariablesResponse toSetVariablesResponse(long key, VariableDocumentRecord brokerResponse) {
        return GatewayOuterClass.SetVariablesResponse.getDefaultInstance();
    }

    public static GatewayOuterClass.ActivateJobsResponse toActivateJobsResponse(long key, JobBatchRecord brokerResponse) {
        GatewayOuterClass.ActivateJobsResponse.Builder responseBuilder = GatewayOuterClass.ActivateJobsResponse.newBuilder();
        Iterator jobKeys = brokerResponse.jobKeys().iterator();
        Iterator jobs = brokerResponse.jobs().iterator();
        while (jobKeys.hasNext() && jobs.hasNext()) {
            LongValue jobKey = (LongValue)jobKeys.next();
            JobRecord job = (JobRecord)jobs.next();
            GatewayOuterClass.ActivatedJob activatedJob = GatewayOuterClass.ActivatedJob.newBuilder().setKey(jobKey.getValue()).setType(BufferUtil.bufferAsString((DirectBuffer)job.getTypeBuffer())).setJobHeaders(ResponseMapper.fromBrokerJobHeaders(job.getJobHeaders())).setCustomHeaders(ResponseMapper.bufferAsJson(job.getCustomHeadersBuffer())).setWorker(BufferUtil.bufferAsString((DirectBuffer)job.getWorkerBuffer())).setRetries(job.getRetries()).setDeadline(job.getDeadlineLong()).setVariables(ResponseMapper.bufferAsJson(job.getVariablesBuffer())).build();
            responseBuilder.addJobs(activatedJob);
        }
        return responseBuilder.build();
    }

    public static GatewayOuterClass.ResolveIncidentResponse toResolveIncidentResponse(long key, IncidentRecord incident) {
        return GatewayOuterClass.ResolveIncidentResponse.getDefaultInstance();
    }

    private static GatewayOuterClass.JobHeaders fromBrokerJobHeaders(JobHeaders headers) {
        return GatewayOuterClass.JobHeaders.newBuilder().setWorkflowInstanceKey(headers.getWorkflowInstanceKey()).setBpmnProcessId(BufferUtil.bufferAsString((DirectBuffer)headers.getBpmnProcessIdBuffer())).setWorkflowDefinitionVersion(headers.getWorkflowDefinitionVersion()).setWorkflowKey(headers.getWorkflowKey()).setElementId(BufferUtil.bufferAsString((DirectBuffer)headers.getElementIdBuffer())).setElementInstanceKey(headers.getElementInstanceKey()).build();
    }

    private static String bufferAsJson(DirectBuffer customHeaders) {
        return MsgPackConverter.convertToJson((byte[])BufferUtil.bufferAsArray((DirectBuffer)customHeaders));
    }

    @FunctionalInterface
    public static interface BrokerResponseMapper<BrokerResponseDto, GrpcResponse> {
        public GrpcResponse apply(long var1, BrokerResponseDto var3);
    }
}

