/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway.cmd;

import io.zeebe.gateway.cmd.ClientException;
import io.zeebe.protocol.PartitionState;

public class UnknownPartitionRoleException
extends ClientException {
    private static final String FORMAT = "Expected broker role for partition '%d' to be one of [LEADER, FOLLOWER], but got '%s'";
    private final int partitionId;
    private final PartitionState state;

    public UnknownPartitionRoleException(int partitionId, PartitionState state) {
        this(partitionId, state, null);
    }

    public UnknownPartitionRoleException(int partitionId, PartitionState state, Throwable cause) {
        super(String.format(FORMAT, partitionId, state), cause);
        this.partitionId = partitionId;
        this.state = state;
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public PartitionState getState() {
        return this.state;
    }
}

