/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway.impl;

import io.zeebe.protocol.record.ErrorCode;
import io.zeebe.protocol.record.ErrorResponseDecoder;
import io.zeebe.protocol.record.MessageHeaderDecoder;
import io.zeebe.util.buffer.BufferUtil;
import org.agrona.DirectBuffer;

public class ErrorResponseHandler {
    protected final ErrorResponseDecoder decoder = new ErrorResponseDecoder();
    protected DirectBuffer errorMessage;

    public boolean handlesResponse(MessageHeaderDecoder responseHeader) {
        return 0 == responseHeader.schemaId() && 0 == responseHeader.templateId();
    }

    public void wrap(DirectBuffer body, int offset, int length, int version) {
        this.decoder.wrap(body, offset, length, version);
        int errorDataLength = this.decoder.errorDataLength();
        byte[] errorData = new byte[errorDataLength];
        this.decoder.getErrorData(errorData, 0, errorDataLength);
        this.errorMessage = BufferUtil.wrapArray((byte[])errorData);
    }

    public ErrorCode getErrorCode() {
        return this.decoder.errorCode();
    }

    public DirectBuffer getErrorMessage() {
        return this.errorMessage;
    }
}

