/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway.impl.broker;

import io.atomix.cluster.AtomixCluster;
import io.atomix.cluster.ClusterMembershipEvent;
import io.atomix.utils.event.EventListener;
import io.zeebe.dispatcher.Dispatcher;
import io.zeebe.dispatcher.Dispatchers;
import io.zeebe.gateway.Loggers;
import io.zeebe.gateway.impl.broker.BrokerClient;
import io.zeebe.gateway.impl.broker.BrokerRequestManager;
import io.zeebe.gateway.impl.broker.BrokerResponseConsumer;
import io.zeebe.gateway.impl.broker.RoundRobinDispatchStrategy;
import io.zeebe.gateway.impl.broker.cluster.BrokerTopologyManager;
import io.zeebe.gateway.impl.broker.cluster.BrokerTopologyManagerImpl;
import io.zeebe.gateway.impl.broker.request.BrokerRequest;
import io.zeebe.gateway.impl.broker.response.BrokerResponse;
import io.zeebe.gateway.impl.configuration.ClusterCfg;
import io.zeebe.gateway.impl.configuration.GatewayCfg;
import io.zeebe.transport.ClientTransport;
import io.zeebe.transport.ClientTransportBuilder;
import io.zeebe.transport.RemoteAddress;
import io.zeebe.transport.SocketAddress;
import io.zeebe.transport.Transports;
import io.zeebe.transport.impl.memory.NonBlockingMemoryPool;
import io.zeebe.transport.impl.memory.TransportMemoryPool;
import io.zeebe.transport.impl.memory.UnboundedMemoryPool;
import io.zeebe.util.ByteValue;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.ActorScheduler;
import io.zeebe.util.sched.clock.ActorClock;
import io.zeebe.util.sched.future.ActorFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import org.slf4j.Logger;

public class BrokerClientImpl
implements BrokerClient {
    public static final Logger LOG = Loggers.GATEWAY_LOGGER;
    protected final ActorScheduler actorScheduler;
    private final boolean ownsActorScheduler;
    protected final ClientTransport transport;
    protected final BrokerTopologyManagerImpl topologyManager;
    private final Dispatcher dataFrameReceiveBuffer;
    private final BrokerRequestManager requestManager;
    protected boolean isClosed;

    public BrokerClientImpl(GatewayCfg configuration, AtomixCluster atomixCluster) {
        this(configuration, atomixCluster, null);
    }

    public BrokerClientImpl(GatewayCfg configuration, AtomixCluster atomixCluster, ActorClock actorClock) {
        this(configuration, atomixCluster, ActorScheduler.newActorScheduler().setCpuBoundActorThreadCount(configuration.getThreads().getManagementThreads()).setIoBoundActorThreadCount(0).setActorClock(actorClock).setSchedulerName("gateway-scheduler").build(), true);
    }

    public BrokerClientImpl(GatewayCfg configuration, AtomixCluster atomixCluster, ActorScheduler actorScheduler, boolean ownsActorScheduler) {
        this.actorScheduler = actorScheduler;
        this.ownsActorScheduler = ownsActorScheduler;
        if (ownsActorScheduler) {
            actorScheduler.start();
        }
        ClusterCfg clusterCfg = configuration.getCluster();
        ByteValue transportBufferSize = clusterCfg.getTransportBuffer();
        this.dataFrameReceiveBuffer = Dispatchers.create((String)"gateway-receive-buffer").bufferSize(transportBufferSize).modePubSub().frameMaxLength(0x100000).actorScheduler(actorScheduler).build();
        ClientTransportBuilder transportBuilder = Transports.newClientTransport((String)"gateway-broker-client").messageMaxLength(0x100000).messageReceiveBuffer(this.dataFrameReceiveBuffer).messageMemoryPool((TransportMemoryPool)new UnboundedMemoryPool()).requestMemoryPool((TransportMemoryPool)new NonBlockingMemoryPool(transportBufferSize)).scheduler(actorScheduler);
        this.transport = transportBuilder.build();
        this.topologyManager = new BrokerTopologyManagerImpl(this::registerEndpoint);
        actorScheduler.submitActor((Actor)this.topologyManager);
        atomixCluster.getMembershipService().addListener((EventListener)this.topologyManager);
        atomixCluster.getMembershipService().getMembers().forEach(member -> this.topologyManager.event(new ClusterMembershipEvent(ClusterMembershipEvent.Type.MEMBER_ADDED, member)));
        this.requestManager = new BrokerRequestManager(this.transport.getOutput(), this.topologyManager, new RoundRobinDispatchStrategy(this.topologyManager), clusterCfg.getRequestTimeout());
        actorScheduler.submitActor((Actor)this.requestManager);
    }

    private void registerEndpoint(int nodeId, SocketAddress socketAddress) {
        this.registerEndpoint(this.transport, nodeId, socketAddress);
    }

    private void registerEndpoint(ClientTransport transport, int nodeId, SocketAddress socketAddress) {
        RemoteAddress endpoint = transport.getEndpoint(nodeId);
        if (endpoint == null || !socketAddress.equals((Object)endpoint.getAddress())) {
            transport.registerEndpoint(nodeId, socketAddress);
        }
    }

    @Override
    public void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        LOG.debug("Closing gateway broker client ...");
        this.doAndLogException(() -> {
            Void cfr_ignored_0 = (Void)this.topologyManager.close().join();
        });
        LOG.debug("topology manager closed");
        this.doAndLogException(() -> ((ClientTransport)this.transport).close());
        LOG.debug("transport closed");
        this.doAndLogException(() -> ((Dispatcher)this.dataFrameReceiveBuffer).close());
        LOG.debug("data frame receive buffer closed");
        if (this.ownsActorScheduler) {
            try {
                this.actorScheduler.stop().get(15L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                throw new RuntimeException("Failed to gracefully shutdown gateway broker client", e);
            }
        }
        LOG.debug("Gateway broker client closed.");
    }

    protected void doAndLogException(Runnable r) {
        try {
            r.run();
        }
        catch (Exception e) {
            LOG.error("Exception when closing client. Ignoring", (Throwable)e);
        }
    }

    @Override
    public <T> ActorFuture<BrokerResponse<T>> sendRequest(BrokerRequest<T> request) {
        return this.requestManager.sendRequest(request);
    }

    @Override
    public <T> void sendRequest(BrokerRequest<T> request, BrokerResponseConsumer<T> responseConsumer, Consumer<Throwable> throwableConsumer) {
        this.requestManager.sendRequest(request, responseConsumer, throwableConsumer);
    }

    @Override
    public BrokerTopologyManager getTopologyManager() {
        return this.topologyManager;
    }

    public ClientTransport getTransport() {
        return this.transport;
    }

    public ActorScheduler getScheduler() {
        return this.actorScheduler;
    }
}

