/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway.impl.broker;

import io.zeebe.gateway.cmd.BrokerErrorException;
import io.zeebe.gateway.cmd.BrokerRejectionException;
import io.zeebe.gateway.cmd.BrokerResponseException;
import io.zeebe.gateway.cmd.ClientOutOfMemoryException;
import io.zeebe.gateway.cmd.ClientResponseException;
import io.zeebe.gateway.cmd.IllegalBrokerResponseException;
import io.zeebe.gateway.cmd.NoTopologyAvailableException;
import io.zeebe.gateway.impl.ErrorResponseHandler;
import io.zeebe.gateway.impl.broker.BrokerResponseConsumer;
import io.zeebe.gateway.impl.broker.RequestDispatchStrategy;
import io.zeebe.gateway.impl.broker.cluster.BrokerClusterState;
import io.zeebe.gateway.impl.broker.cluster.BrokerTopologyManagerImpl;
import io.zeebe.gateway.impl.broker.request.BrokerPublishMessageRequest;
import io.zeebe.gateway.impl.broker.request.BrokerRequest;
import io.zeebe.gateway.impl.broker.response.BrokerError;
import io.zeebe.gateway.impl.broker.response.BrokerRejection;
import io.zeebe.gateway.impl.broker.response.BrokerResponse;
import io.zeebe.protocol.impl.SubscriptionUtil;
import io.zeebe.protocol.record.ErrorCode;
import io.zeebe.protocol.record.MessageHeaderDecoder;
import io.zeebe.transport.ClientOutput;
import io.zeebe.transport.ClientResponse;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.future.ActorFuture;
import io.zeebe.util.sched.future.CompletableActorFuture;
import java.time.Duration;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.agrona.DirectBuffer;

public class BrokerRequestManager
extends Actor {
    private final ClientOutput clientOutput;
    private final RequestDispatchStrategy dispatchStrategy;
    private final BrokerTopologyManagerImpl topologyManager;
    private final Duration requestTimeout;

    public BrokerRequestManager(ClientOutput clientOutput, BrokerTopologyManagerImpl topologyManager, RequestDispatchStrategy dispatchStrategy, Duration requestTimeout) {
        this.clientOutput = clientOutput;
        this.dispatchStrategy = dispatchStrategy;
        this.topologyManager = topologyManager;
        this.requestTimeout = requestTimeout;
    }

    private static boolean shouldRetryRequest(DirectBuffer responseContent) {
        ErrorResponseHandler errorHandler = new ErrorResponseHandler();
        MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
        headerDecoder.wrap(responseContent, 0);
        if (errorHandler.handlesResponse(headerDecoder)) {
            errorHandler.wrap(responseContent, headerDecoder.encodedLength(), headerDecoder.blockLength(), headerDecoder.version());
            ErrorCode errorCode = errorHandler.getErrorCode();
            return errorCode == ErrorCode.PARTITION_LEADER_MISMATCH;
        }
        return false;
    }

    public <T> ActorFuture<BrokerResponse<T>> sendRequest(BrokerRequest<T> request) {
        CompletableActorFuture responseFuture = new CompletableActorFuture();
        this.sendRequest(request, (arg_0, arg_1) -> BrokerRequestManager.lambda$sendRequest$0((ActorFuture)responseFuture, arg_0, arg_1));
        return responseFuture;
    }

    public <T> void sendRequest(BrokerRequest<T> request, BrokerResponseConsumer<T> responseConsumer, Consumer<Throwable> throwableConsumer) {
        this.sendRequest(request, responseConsumer, rejection -> throwableConsumer.accept(new BrokerRejectionException((BrokerRejection)rejection)), error -> throwableConsumer.accept(new BrokerErrorException((BrokerError)error)), throwableConsumer);
    }

    private <T> void sendRequest(BrokerRequest<T> request, BrokerResponseConsumer<T> responseConsumer, Consumer<BrokerRejection> rejectionConsumer, Consumer<BrokerError> errorConsumer, Consumer<Throwable> throwableConsumer) {
        this.sendRequest(request, (response, error) -> {
            try {
                if (error == null) {
                    if (response.isResponse()) {
                        responseConsumer.accept(response.getKey(), response.getResponse());
                    } else if (response.isRejection()) {
                        rejectionConsumer.accept(response.getRejection());
                    } else if (response.isError()) {
                        errorConsumer.accept(response.getError());
                    } else {
                        throwableConsumer.accept(new IllegalBrokerResponseException("Expected broker response to be either response, rejection, or error, but is neither of them"));
                    }
                } else {
                    throwableConsumer.accept((Throwable)error);
                }
            }
            catch (RuntimeException e) {
                throwableConsumer.accept(new BrokerResponseException(e));
            }
        });
    }

    private <T> void sendRequest(BrokerRequest<T> request, BiConsumer<BrokerResponse<T>, Throwable> responseConsumer) {
        request.serializeValue();
        this.actor.run(() -> this.sendRequestInternal(request, responseConsumer));
    }

    private <T> void sendRequestInternal(BrokerRequest<T> request, BiConsumer<BrokerResponse<T>, Throwable> responseConsumer) {
        BrokerNodeIdProvider nodeIdProvider = this.determineBrokerNodeIdProvider(request);
        ActorFuture responseFuture = this.clientOutput.sendRequestWithRetry((Supplier)nodeIdProvider, BrokerRequestManager::shouldRetryRequest, request, this.requestTimeout);
        if (responseFuture != null) {
            this.actor.runOnCompletion(responseFuture, (clientResponse, error) -> {
                try {
                    if (error == null) {
                        BrokerResponse response = request.getResponse((ClientResponse)clientResponse);
                        responseConsumer.accept(response, null);
                    } else {
                        responseConsumer.accept((BrokerResponse<Object>)null, (Throwable)error);
                    }
                }
                catch (RuntimeException e) {
                    responseConsumer.accept(null, new ClientResponseException(e));
                }
            });
        } else {
            responseConsumer.accept(null, new ClientOutOfMemoryException());
        }
    }

    private BrokerNodeIdProvider determineBrokerNodeIdProvider(BrokerRequest<?> request) {
        if (request.addressesSpecificPartition()) {
            return new BrokerNodeIdProvider(request.getPartitionId());
        }
        if (request.requiresPartitionId()) {
            if (request instanceof BrokerPublishMessageRequest) {
                this.determinePartitionIdForPublishMessageRequest((BrokerPublishMessageRequest)request);
            } else {
                int partitionId = this.dispatchStrategy.determinePartition();
                if (partitionId == -3) {
                    partitionId = 1;
                }
                request.setPartitionId(partitionId);
            }
            return new BrokerNodeIdProvider(request.getPartitionId());
        }
        return new BrokerNodeIdProvider();
    }

    private void determinePartitionIdForPublishMessageRequest(BrokerPublishMessageRequest request) {
        BrokerClusterState topology = this.topologyManager.getTopology();
        if (topology == null) {
            throw new NoTopologyAvailableException(String.format("Expected to pick partition for message with correlation key '%s', but no topology is available", request.getCorrelationKey()));
        }
        int partitionsCount = topology.getPartitionsCount();
        int partitionId = SubscriptionUtil.getSubscriptionPartitionId((DirectBuffer)request.getCorrelationKey(), (int)partitionsCount);
        request.setPartitionId(partitionId);
    }

    private static /* synthetic */ void lambda$sendRequest$0(ActorFuture responseFuture, BrokerResponse response, Throwable error) {
        if (error == null) {
            responseFuture.complete((Object)response);
        } else {
            responseFuture.completeExceptionally(error);
        }
    }

    private class BrokerNodeIdProvider
    implements Supplier<Integer> {
        private final Function<BrokerClusterState, Integer> nodeIdSelector;

        BrokerNodeIdProvider() {
            this(BrokerClusterState::getRandomBroker);
        }

        BrokerNodeIdProvider(int partitionId) {
            this(state -> state.getLeaderForPartition(partitionId));
        }

        BrokerNodeIdProvider(Function<BrokerClusterState, Integer> nodeIdSelector) {
            this.nodeIdSelector = nodeIdSelector;
        }

        @Override
        public Integer get() {
            BrokerClusterState topology = BrokerRequestManager.this.topologyManager.getTopology();
            if (topology != null) {
                return this.nodeIdSelector.apply(topology);
            }
            return null;
        }
    }
}

