/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway.impl.broker;

import io.zeebe.gateway.impl.broker.RequestDispatchStrategy;
import io.zeebe.gateway.impl.broker.cluster.BrokerClusterState;
import io.zeebe.gateway.impl.broker.cluster.BrokerTopologyManagerImpl;
import java.util.concurrent.atomic.AtomicInteger;

public class RoundRobinDispatchStrategy
implements RequestDispatchStrategy {
    protected final BrokerTopologyManagerImpl topologyManager;
    protected final AtomicInteger partitions = new AtomicInteger(0);

    public RoundRobinDispatchStrategy(BrokerTopologyManagerImpl topologyManager) {
        this.topologyManager = topologyManager;
    }

    @Override
    public int determinePartition() {
        BrokerClusterState topology = this.topologyManager.getTopology();
        if (topology != null) {
            int offset = this.partitions.getAndIncrement();
            return topology.getPartition(offset);
        }
        return -3;
    }
}

