/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway.impl.broker.cluster;

import io.zeebe.gateway.impl.broker.cluster.BrokerClusterState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.agrona.collections.Int2IntHashMap;
import org.agrona.collections.Int2ObjectHashMap;
import org.agrona.collections.IntArrayList;

public class BrokerClusterStateImpl
implements BrokerClusterState {
    private final Int2IntHashMap partitionLeaders = new Int2IntHashMap(-2);
    private final Int2ObjectHashMap<List<Integer>> partitionFollowers = new Int2ObjectHashMap();
    private final Int2ObjectHashMap<String> brokerAddresses = new Int2ObjectHashMap();
    private final IntArrayList brokers = new IntArrayList(5, -2);
    private final IntArrayList partitions = new IntArrayList(32, -3);
    private final Random randomBroker = new Random();
    private int clusterSize;
    private int partitionsCount;
    private int replicationFactor;

    public BrokerClusterStateImpl(BrokerClusterStateImpl topology) {
        this();
        if (topology != null) {
            this.partitionLeaders.putAll((Map)topology.partitionLeaders);
            this.partitionFollowers.putAll(topology.partitionFollowers);
            this.brokerAddresses.putAll(topology.brokerAddresses);
            this.brokers.addAll((Collection)topology.brokers);
            this.partitions.addAll((Collection)topology.partitions);
            this.clusterSize = topology.clusterSize;
            this.partitionsCount = topology.partitionsCount;
            this.replicationFactor = topology.replicationFactor;
        }
    }

    public BrokerClusterStateImpl() {
    }

    public void setPartitionLeader(int partitionId, int leaderId) {
        this.partitionLeaders.put(partitionId, leaderId);
        List followers = (List)this.partitionFollowers.get(partitionId);
        if (followers != null) {
            followers.removeIf(follower -> follower == leaderId);
        }
    }

    public void addPartitionFollower(int partitionId, int followerId) {
        ((List)this.partitionFollowers.computeIfAbsent(partitionId, ArrayList::new)).add(followerId);
    }

    public void addPartitionIfAbsent(int partitionId) {
        if (this.partitions.indexOf(partitionId) == -1) {
            this.partitions.addInt(partitionId);
        }
    }

    public void addBrokerIfAbsent(int nodeId) {
        if (this.brokerAddresses.get(nodeId) == null) {
            this.brokerAddresses.put(nodeId, (Object)"");
            this.brokers.addInt(nodeId);
        }
    }

    public void setBrokerAddressIfPresent(int brokerId, String address) {
        if (this.brokerAddresses.get(brokerId) != null) {
            this.brokerAddresses.put(brokerId, (Object)address);
        }
    }

    public void removeBroker(int brokerId) {
        this.brokerAddresses.remove(brokerId);
        this.brokers.removeInt(brokerId);
        this.partitions.forEachOrderedInt(partitionId -> {
            List followers;
            if (this.partitionLeaders.get(partitionId) == brokerId) {
                this.partitionLeaders.remove(partitionId);
            }
            if ((followers = (List)this.partitionFollowers.get(partitionId)) != null) {
                followers.remove(new Integer(brokerId));
            }
        });
    }

    @Override
    public int getClusterSize() {
        return this.clusterSize;
    }

    public void setClusterSize(int clusterSize) {
        this.clusterSize = clusterSize;
    }

    @Override
    public int getPartitionsCount() {
        return this.partitionsCount;
    }

    public void setPartitionsCount(int partitionsCount) {
        this.partitionsCount = partitionsCount;
    }

    @Override
    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    public void setReplicationFactor(int replicationFactor) {
        this.replicationFactor = replicationFactor;
    }

    @Override
    public int getLeaderForPartition(int partition) {
        return this.partitionLeaders.get(partition);
    }

    @Override
    public List<Integer> getFollowersForPartition(int partition) {
        return (List)this.partitionFollowers.get(partition);
    }

    @Override
    public int getRandomBroker() {
        if (this.brokers.isEmpty()) {
            return -1;
        }
        return this.brokers.get(this.randomBroker.nextInt(this.brokers.size()));
    }

    @Override
    public List<Integer> getPartitions() {
        return this.partitions;
    }

    @Override
    public List<Integer> getBrokers() {
        return this.brokers;
    }

    @Override
    public String getBrokerAddress(int brokerId) {
        return (String)this.brokerAddresses.get(brokerId);
    }

    @Override
    public int getPartition(int index) {
        if (!this.partitions.isEmpty()) {
            return this.partitions.getInt(index % this.partitions.size());
        }
        return -3;
    }

    public String toString() {
        return "BrokerClusterStateImpl{partitionLeaders=" + this.partitionLeaders + ", brokers=" + this.brokers + ", partitions=" + this.partitions + ", clusterSize=" + this.clusterSize + ", partitionsCount=" + this.partitionsCount + ", replicationFactor=" + this.replicationFactor + '}';
    }
}

