/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway.impl.broker.cluster;

import io.atomix.cluster.ClusterMembershipEvent;
import io.atomix.cluster.ClusterMembershipEventListener;
import io.atomix.cluster.Member;
import io.zeebe.gateway.Loggers;
import io.zeebe.gateway.impl.broker.cluster.BrokerClusterState;
import io.zeebe.gateway.impl.broker.cluster.BrokerClusterStateImpl;
import io.zeebe.gateway.impl.broker.cluster.BrokerTopologyManager;
import io.zeebe.protocol.impl.data.cluster.BrokerInfo;
import io.zeebe.transport.SocketAddress;
import io.zeebe.util.sched.Actor;
import io.zeebe.util.sched.future.ActorFuture;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import org.slf4j.Logger;

public class BrokerTopologyManagerImpl
extends Actor
implements BrokerTopologyManager,
ClusterMembershipEventListener {
    private static final Logger LOG = Loggers.GATEWAY_LOGGER;
    protected final BiConsumer<Integer, SocketAddress> registerEndpoint;
    protected final AtomicReference<BrokerClusterStateImpl> topology;

    public BrokerTopologyManagerImpl(BiConsumer<Integer, SocketAddress> registerEndpoint) {
        this.registerEndpoint = registerEndpoint;
        this.topology = new AtomicReference<Object>(null);
    }

    public ActorFuture<Void> close() {
        return this.actor.close();
    }

    @Override
    public BrokerClusterState getTopology() {
        return this.topology.get();
    }

    public void setTopology(BrokerClusterStateImpl topology) {
        this.topology.set(topology);
    }

    public void event(ClusterMembershipEvent event) {
        Member subject = (Member)event.subject();
        ClusterMembershipEvent.Type eventType = (ClusterMembershipEvent.Type)event.type();
        BrokerInfo brokerInfo = BrokerInfo.fromProperties((Properties)subject.properties());
        LOG.debug("Got membership event {}", (Object)brokerInfo);
        if (brokerInfo != null) {
            this.actor.call(() -> {
                Loggers.GATEWAY_LOGGER.debug("Received membership event: {}", (Object)event);
                BrokerClusterStateImpl newTopology = new BrokerClusterStateImpl(this.topology.get());
                switch (eventType) {
                    case MEMBER_ADDED: {
                        newTopology.addBrokerIfAbsent(brokerInfo.getNodeId());
                        this.processProperties(brokerInfo, newTopology);
                        break;
                    }
                    case METADATA_CHANGED: {
                        this.processProperties(brokerInfo, newTopology);
                        break;
                    }
                    case MEMBER_REMOVED: {
                        newTopology.removeBroker(brokerInfo.getNodeId());
                    }
                }
                this.topology.set(newTopology);
            });
        }
    }

    private void processProperties(BrokerInfo distributedBrokerInfo, BrokerClusterStateImpl newTopology) {
        newTopology.setClusterSize(distributedBrokerInfo.getClusterSize());
        newTopology.setPartitionsCount(distributedBrokerInfo.getPartitionsCount());
        newTopology.setReplicationFactor(distributedBrokerInfo.getReplicationFactor());
        int nodeId = distributedBrokerInfo.getNodeId();
        distributedBrokerInfo.consumePartitions(newTopology::addPartitionIfAbsent, leaderPartitionId -> newTopology.setPartitionLeader((int)leaderPartitionId, nodeId), followerPartitionId -> newTopology.addPartitionFollower((int)followerPartitionId, nodeId));
        String clientAddress = distributedBrokerInfo.getApiAddress("command");
        if (clientAddress != null) {
            newTopology.setBrokerAddressIfPresent(nodeId, clientAddress);
            this.registerEndpoint.accept(nodeId, SocketAddress.from((String)clientAddress));
        }
    }
}

