/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway.impl.broker.request;

import io.zeebe.gateway.cmd.InvalidBrokerRequestArgumentException;
import io.zeebe.gateway.impl.broker.request.BrokerExecuteCommand;
import io.zeebe.gateway.protocol.GatewayOuterClass;
import io.zeebe.protocol.impl.record.value.deployment.DeploymentRecord;
import io.zeebe.protocol.impl.record.value.deployment.DeploymentResource;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.intent.DeploymentIntent;
import io.zeebe.protocol.record.intent.Intent;
import io.zeebe.protocol.record.value.deployment.ResourceType;
import org.agrona.DirectBuffer;

public class BrokerDeployWorkflowRequest
extends BrokerExecuteCommand<DeploymentRecord> {
    private final DeploymentRecord requestDto = new DeploymentRecord();

    public BrokerDeployWorkflowRequest() {
        super(ValueType.DEPLOYMENT, (Intent)DeploymentIntent.CREATE);
        this.setPartitionId(1);
    }

    public BrokerDeployWorkflowRequest addResource(byte[] resource, String resourceName, GatewayOuterClass.WorkflowRequestObject.ResourceType resourceType) {
        ((DeploymentResource)this.requestDto.resources().add()).setResource(resource).setResourceName(resourceName).setResourceType(this.determineResourceType(resourceName, resourceType));
        return this;
    }

    private ResourceType determineResourceType(String resourceName, GatewayOuterClass.WorkflowRequestObject.ResourceType resourceType) {
        switch (resourceType) {
            case BPMN: {
                return ResourceType.BPMN_XML;
            }
            case YAML: {
                return ResourceType.YAML_WORKFLOW;
            }
        }
        try {
            return DeploymentResource.getResourceType((String)resourceName);
        }
        catch (RuntimeException e) {
            throw new InvalidBrokerRequestArgumentException("name", "a string ending with either .bpmn or .yaml", resourceName, e);
        }
    }

    public DeploymentRecord getRequestWriter() {
        return this.requestDto;
    }

    @Override
    protected DeploymentRecord toResponseDto(DirectBuffer buffer) {
        DeploymentRecord responseDto = new DeploymentRecord();
        responseDto.wrap(buffer);
        return responseDto;
    }
}

