/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway.impl.broker.request;

import io.zeebe.gateway.cmd.UnsupportedBrokerResponseException;
import io.zeebe.gateway.impl.broker.request.BrokerRequest;
import io.zeebe.gateway.impl.broker.response.BrokerRejection;
import io.zeebe.gateway.impl.broker.response.BrokerRejectionResponse;
import io.zeebe.gateway.impl.broker.response.BrokerResponse;
import io.zeebe.protocol.impl.encoding.ExecuteCommandRequest;
import io.zeebe.protocol.impl.encoding.ExecuteCommandResponse;
import io.zeebe.protocol.record.ExecuteCommandRequestEncoder;
import io.zeebe.protocol.record.RecordType;
import io.zeebe.protocol.record.ValueType;
import io.zeebe.protocol.record.intent.Intent;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public abstract class BrokerExecuteCommand<T>
extends BrokerRequest<T> {
    protected final ExecuteCommandRequest request = new ExecuteCommandRequest();
    protected final ExecuteCommandResponse response = new ExecuteCommandResponse();

    public BrokerExecuteCommand(ValueType valueType, Intent intent) {
        super(0, 21);
        this.request.setValueType(valueType);
        this.request.setIntent(intent);
    }

    public long getKey() {
        return this.request.getKey();
    }

    public Intent getIntent() {
        return this.request.getIntent();
    }

    public ValueType getValueType() {
        return this.request.getValueType();
    }

    @Override
    public int getPartitionId() {
        return this.request.getPartitionId();
    }

    @Override
    public void setPartitionId(int partitionId) {
        this.request.setPartitionId(partitionId);
    }

    @Override
    public boolean addressesSpecificPartition() {
        return this.getPartitionId() != ExecuteCommandRequestEncoder.partitionIdNullValue();
    }

    @Override
    public boolean requiresPartitionId() {
        return true;
    }

    @Override
    protected void setSerializedValue(DirectBuffer buffer) {
        this.request.setValue(buffer, 0, buffer.capacity());
    }

    public int getLength() {
        return this.request.getLength();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.request.write(buffer, offset);
    }

    @Override
    protected void wrapResponse(DirectBuffer buffer) {
        this.response.wrap(buffer, 0, buffer.capacity());
    }

    @Override
    protected BrokerResponse<T> readResponse() {
        if (this.isRejection()) {
            BrokerRejection brokerRejection = new BrokerRejection(this.request.getIntent(), this.request.getKey(), this.response.getRejectionType(), this.response.getRejectionReason());
            return new BrokerRejectionResponse(brokerRejection);
        }
        if (this.isValidValueType()) {
            Object responseDto = this.toResponseDto(this.response.getValue());
            return new BrokerResponse(responseDto, this.response.getPartitionId(), this.response.getKey());
        }
        throw new UnsupportedBrokerResponseException(this.request.getValueType().name(), this.response.getValueType().name());
    }

    private boolean isValidValueType() {
        return this.response.getValueType() == this.request.getValueType();
    }

    protected boolean isRejection() {
        return this.response.getRecordType() == RecordType.COMMAND_REJECTION;
    }
}

