/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway.impl.configuration;

import io.zeebe.util.ByteValue;
import io.zeebe.util.DurationUtil;
import io.zeebe.util.Environment;
import java.time.Duration;
import java.util.Objects;

public class ClusterCfg {
    private String contactPoint = "127.0.0.1:26502";
    private String transportBuffer = "128M";
    private String requestTimeout = "15s";
    private String clusterName = "zeebe-cluster";
    private String memberId = "gateway";
    private String host = "0.0.0.0";
    private int port = 26502;

    public void init(Environment environment) {
        environment.get("ZEEBE_GATEWAY_CONTACT_POINT").map(v -> v.contains(":") ? v : v + ":" + 26502).ifPresent(this::setContactPoint);
        environment.get("ZEEBE_GATEWAY_TRANSPORT_BUFFER").ifPresent(this::setTransportBuffer);
        environment.get("ZEEBE_GATEWAY_REQUEST_TIMEOUT").ifPresent(this::setRequestTimeout);
        environment.get("ZEEBE_GATEWAY_CLUSTER_NAME").ifPresent(this::setClusterName);
        environment.get("ZEEBE_GATEWAY_CLUSTER_MEMBER_ID").ifPresent(this::setMemberId);
        environment.get("ZEEBE_GATEWAY_CLUSTER_HOST").ifPresent(this::setHost);
        environment.getInt("ZEEBE_GATEWAY_CLUSTER_PORT").ifPresent(this::setPort);
    }

    public String getMemberId() {
        return this.memberId;
    }

    public ClusterCfg setMemberId(String memberId) {
        this.memberId = memberId;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public ClusterCfg setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public ClusterCfg setPort(int port) {
        this.port = port;
        return this;
    }

    public String getContactPoint() {
        return this.contactPoint;
    }

    public ClusterCfg setContactPoint(String contactPoint) {
        this.contactPoint = contactPoint;
        return this;
    }

    public ByteValue getTransportBuffer() {
        return new ByteValue(this.transportBuffer);
    }

    public ClusterCfg setTransportBuffer(String transportBuffer) {
        this.transportBuffer = transportBuffer;
        return this;
    }

    public Duration getRequestTimeout() {
        return DurationUtil.parse((String)this.requestTimeout);
    }

    public ClusterCfg setRequestTimeout(String requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public String getClusterName() {
        return this.clusterName;
    }

    public ClusterCfg setClusterName(String name) {
        this.clusterName = name;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterCfg that = (ClusterCfg)o;
        return Objects.equals(this.contactPoint, that.contactPoint) && Objects.equals(this.transportBuffer, that.transportBuffer) && Objects.equals(this.requestTimeout, that.requestTimeout) && Objects.equals(this.clusterName, that.clusterName);
    }

    public int hashCode() {
        return Objects.hash(this.contactPoint, this.transportBuffer, this.requestTimeout, this.clusterName);
    }

    public String toString() {
        return "ClusterCfg{contactPoint='" + this.contactPoint + '\'' + ", transportBuffer='" + this.transportBuffer + '\'' + ", requestTimeout='" + this.requestTimeout + '\'' + ", clusterName='" + this.clusterName + '\'' + '}';
    }
}

