/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway.impl.configuration;

import com.google.gson.GsonBuilder;
import io.zeebe.gateway.impl.configuration.ClusterCfg;
import io.zeebe.gateway.impl.configuration.NetworkCfg;
import io.zeebe.gateway.impl.configuration.ThreadsCfg;
import io.zeebe.util.Environment;
import java.util.Objects;

public class GatewayCfg {
    private NetworkCfg network = new NetworkCfg();
    private ClusterCfg cluster = new ClusterCfg();
    private ThreadsCfg threads = new ThreadsCfg();

    public void init() {
        this.init(new Environment());
    }

    public void init(Environment environment) {
        this.init(environment, "0.0.0.0");
    }

    public void init(Environment environment, String defaultHost) {
        this.network.init(environment, defaultHost);
        this.cluster.init(environment);
        this.threads.init(environment);
    }

    public NetworkCfg getNetwork() {
        return this.network;
    }

    public GatewayCfg setNetwork(NetworkCfg network) {
        this.network = network;
        return this;
    }

    public ClusterCfg getCluster() {
        return this.cluster;
    }

    public GatewayCfg setCluster(ClusterCfg cluster) {
        this.cluster = cluster;
        return this;
    }

    public ThreadsCfg getThreads() {
        return this.threads;
    }

    public GatewayCfg setThreads(ThreadsCfg threads) {
        this.threads = threads;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GatewayCfg that = (GatewayCfg)o;
        return Objects.equals(this.network, that.network) && Objects.equals(this.cluster, that.cluster) && Objects.equals(this.threads, that.threads);
    }

    public int hashCode() {
        return Objects.hash(this.network, this.cluster, this.threads);
    }

    public String toString() {
        return "GatewayCfg{networkCfg=" + this.network + ", clusterCfg=" + this.cluster + ", threadsCfg=" + this.threads + '}';
    }

    public String toJson() {
        return new GsonBuilder().setPrettyPrinting().create().toJson((Object)this);
    }
}

