/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway.impl.configuration;

import io.zeebe.transport.SocketAddress;
import io.zeebe.util.Environment;
import java.util.Objects;

public class NetworkCfg {
    private String host;
    private int port = 26500;

    public void init(Environment environment, String defaultHost) {
        environment.get("ZEEBE_GATEWAY_HOST").ifPresent(this::setHost);
        environment.getInt("ZEEBE_GATEWAY_PORT").ifPresent(this::setPort);
        if (this.host == null) {
            this.host = defaultHost;
        }
    }

    public String getHost() {
        return this.host;
    }

    public NetworkCfg setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public NetworkCfg setPort(int port) {
        this.port = port;
        return this;
    }

    public SocketAddress toSocketAddress() {
        return new SocketAddress(this.host, this.port);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NetworkCfg that = (NetworkCfg)o;
        return this.port == that.port && Objects.equals(this.host, that.host);
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public String toString() {
        return "NetworkCfg{host='" + this.host + '\'' + ", port=" + this.port + '}';
    }
}

