/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway.impl.job;

import io.grpc.stub.StreamObserver;
import io.zeebe.gateway.Loggers;
import io.zeebe.gateway.RequestMapper;
import io.zeebe.gateway.ResponseMapper;
import io.zeebe.gateway.impl.broker.BrokerClient;
import io.zeebe.gateway.impl.broker.request.BrokerActivateJobsRequest;
import io.zeebe.gateway.impl.job.PartitionIdIterator;
import io.zeebe.gateway.protocol.GatewayOuterClass;
import java.util.HashMap;
import java.util.Map;

public class ActivateJobsHandler {
    private final Map<String, Integer> jobTypeToNextPartitionId = new HashMap<String, Integer>();
    private final BrokerClient brokerClient;

    public ActivateJobsHandler(BrokerClient brokerClient) {
        this.brokerClient = brokerClient;
    }

    public void activateJobs(int partitionsCount, GatewayOuterClass.ActivateJobsRequest request, StreamObserver<GatewayOuterClass.ActivateJobsResponse> responseObserver) {
        this.activateJobs(RequestMapper.toActivateJobsRequest(request), this.partitionIdIteratorForType(request.getType(), partitionsCount), request.getMaxJobsToActivate(), request.getType(), responseObserver);
    }

    private void activateJobs(BrokerActivateJobsRequest request, PartitionIdIterator partitionIdIterator, int remainingAmount, String jobType, StreamObserver<GatewayOuterClass.ActivateJobsResponse> responseObserver) {
        this.activateJobs(request, partitionIdIterator, remainingAmount, jobType, responseObserver, false);
    }

    private void activateJobs(BrokerActivateJobsRequest request, PartitionIdIterator partitionIdIterator, int remainingAmount, String jobType, StreamObserver<GatewayOuterClass.ActivateJobsResponse> responseObserver, boolean pollPrevPartition) {
        if (remainingAmount > 0 && (pollPrevPartition || partitionIdIterator.hasNext())) {
            int partitionId = pollPrevPartition ? partitionIdIterator.getCurrentPartitionId() : partitionIdIterator.next().intValue();
            request.setPartitionId(partitionId);
            request.setMaxJobsToActivate(remainingAmount);
            this.brokerClient.sendRequest(request, (key, response) -> {
                GatewayOuterClass.ActivateJobsResponse grpcResponse = ResponseMapper.toActivateJobsResponse(key, response);
                int jobsCount = grpcResponse.getJobsCount();
                if (jobsCount > 0) {
                    responseObserver.onNext((Object)grpcResponse);
                }
                this.activateJobs(request, partitionIdIterator, remainingAmount - jobsCount, jobType, responseObserver, response.getTruncated());
            }, error -> {
                Loggers.GATEWAY_LOGGER.warn("Failed to activate jobs for type {} from partition {}", new Object[]{jobType, partitionIdIterator.getCurrentPartitionId(), error});
                this.activateJobs(request, partitionIdIterator, remainingAmount, jobType, responseObserver);
            });
        } else {
            this.jobTypeToNextPartitionId.put(jobType, partitionIdIterator.getCurrentPartitionId());
            responseObserver.onCompleted();
        }
    }

    private PartitionIdIterator partitionIdIteratorForType(String jobType, int partitionsCount) {
        Integer nextPartitionId = this.jobTypeToNextPartitionId.computeIfAbsent(jobType, t -> 0);
        return new PartitionIdIterator(nextPartitionId, partitionsCount);
    }
}

