/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.gateway.impl.job;

import java.util.Iterator;
import java.util.PrimitiveIterator;
import java.util.stream.IntStream;

public class PartitionIdIterator
implements Iterator<Integer> {
    private final PrimitiveIterator.OfInt iterator;
    private int currentPartitionId;

    public PartitionIdIterator(int startPartitionId, int partitionsCount) {
        this.iterator = IntStream.range(0, partitionsCount).map(index -> (index + startPartitionId) % partitionsCount + 1).iterator();
    }

    @Override
    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    @Override
    public Integer next() {
        this.currentPartitionId = this.iterator.next();
        return this.currentPartitionId;
    }

    public int getCurrentPartitionId() {
        return this.currentPartitionId;
    }
}

