/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.config;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigException;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigList;
import com.typesafe.config.ConfigMemorySize;
import com.typesafe.config.ConfigMergeable;
import com.typesafe.config.ConfigObject;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigValue;
import io.atomix.utils.Named;
import io.atomix.utils.config.ConfigurationException;
import io.atomix.utils.config.NamedConfig;
import io.atomix.utils.memory.MemorySize;
import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigMapper.class);
    private final ClassLoader classLoader;

    public ConfigMapper(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public <T> T loadFiles(Class<T> type, List<File> files, List<String> resources) {
        if (files == null) {
            return this.loadResources(type, resources);
        }
        Config config = ConfigFactory.systemProperties();
        for (File file : files) {
            config = config.withFallback((ConfigMergeable)ConfigFactory.parseFile((File)file, (ConfigParseOptions)ConfigParseOptions.defaults().setAllowMissing(false)));
        }
        for (String resource : resources) {
            config = config.withFallback((ConfigMergeable)ConfigFactory.load((ClassLoader)this.classLoader, (String)resource));
        }
        return this.map(((Config)Preconditions.checkNotNull((Object)config, (Object)"config cannot be null")).resolve(), type);
    }

    public <T> T loadResources(Class<T> type, String ... resources) {
        return this.loadResources(type, Arrays.asList(resources));
    }

    public <T> T loadResources(Class<T> type, List<String> resources) {
        if (resources == null || resources.isEmpty()) {
            throw new IllegalArgumentException("resources must be defined");
        }
        Config config = null;
        for (String resource : resources) {
            if (config == null) {
                config = ConfigFactory.load((ClassLoader)this.classLoader, (String)resource);
                continue;
            }
            config = config.withFallback((ConfigMergeable)ConfigFactory.load((ClassLoader)this.classLoader, (String)resource));
        }
        return this.map(((Config)Preconditions.checkNotNull(config, (Object)"config cannot be null")).resolve(), type);
    }

    protected <T> T map(Config config, Class<T> clazz) {
        return this.map(config, null, null, clazz);
    }

    protected <T> T newInstance(Config config, String key, Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ConfigurationException(clazz.getName() + " needs a public no-args constructor to be used as a bean", e);
        }
    }

    protected <T> T map(Config config, String path, String name, Class<T> clazz) {
        T instance = this.newInstance(config, name, clazz);
        HashMap<String, String> propertyNames = new HashMap<String, String>();
        for (Map.Entry configProp : config.root().entrySet()) {
            String originalName = (String)configProp.getKey();
            String camelName = ConfigMapper.toCamelCase(originalName);
            if (propertyNames.containsKey(camelName) && !originalName.equals(camelName)) continue;
            propertyNames.put(camelName, originalName);
        }
        this.mapSetters(instance, clazz, path, name, propertyNames, config);
        this.mapFields(instance, clazz, path, name, propertyNames, config);
        if (!propertyNames.isEmpty()) {
            this.checkRemainingProperties(propertyNames.keySet(), this.describeProperties(instance), this.toPath(path, name), clazz);
        }
        return instance;
    }

    protected void checkRemainingProperties(Set<String> missingProperties, List<String> availableProperties, String path, Class<?> clazz) {
        Properties properties = System.getProperties();
        List cleanNames = missingProperties.stream().map(propertyName -> this.toPath(path, (String)propertyName)).filter(propertyName -> !properties.containsKey(propertyName)).filter(propertyName -> properties.entrySet().stream().noneMatch(entry -> entry.getKey().toString().startsWith(propertyName + "."))).sorted().collect(Collectors.toList());
        if (!cleanNames.isEmpty()) {
            throw new ConfigurationException("Unknown properties present in configuration: " + Joiner.on((String)", ").join(cleanNames) + "\nAvailable properties:\n- " + Joiner.on((String)"\n- ").join(availableProperties));
        }
    }

    private List<String> describeProperties(Object instance) {
        Stream<String> setters = ConfigMapper.getSetterDescriptors(instance.getClass()).stream().map(descriptor -> ((SetterDescriptor)descriptor).name);
        Stream<String> fields = ConfigMapper.getFieldDescriptors(instance.getClass()).stream().map(descriptor -> ((FieldDescriptor)descriptor).name);
        return Stream.concat(setters, fields).sorted().collect(Collectors.toList());
    }

    private <T> void mapSetters(T instance, Class<T> clazz, String path, String name, Map<String, String> propertyNames, Config config) {
        try {
            for (SetterDescriptor descriptor : ConfigMapper.getSetterDescriptors(instance.getClass())) {
                Method setter = descriptor.setter;
                Type parameterType = setter.getGenericParameterTypes()[0];
                Class<?> parameterClass = setter.getParameterTypes()[0];
                String configPropName = propertyNames.remove(descriptor.name);
                if (configPropName == null) {
                    if (!Named.class.isAssignableFrom(clazz) && !NamedConfig.class.isAssignableFrom(clazz) || descriptor.setter.getParameterTypes()[0] != String.class || name == null || !descriptor.name.equals("name")) continue;
                    if (descriptor.deprecated) {
                        if (path == null) {
                            LOGGER.warn("{} is deprecated!", (Object)name);
                        } else {
                            LOGGER.warn("{}.{} is deprecated!", (Object)path, (Object)name);
                        }
                    }
                    setter.invoke(instance, name);
                    continue;
                }
                Object value = this.getValue(instance.getClass(), parameterType, parameterClass, config, this.toPath(path, name), configPropName);
                if (value == null) continue;
                if (descriptor.deprecated) {
                    if (path == null) {
                        LOGGER.warn("{}.{} is deprecated!", (Object)name, (Object)configPropName);
                    } else {
                        LOGGER.warn("{}.{}.{} is deprecated!", new Object[]{path, name, configPropName});
                    }
                }
                setter.invoke(instance, value);
            }
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(instance.getClass().getName() + " getters and setters are not accessible, they must be for use as a bean", e);
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException("Calling bean method on " + instance.getClass().getName() + " caused an exception", e);
        }
    }

    private <T> void mapFields(T instance, Class<T> clazz, String path, String name, Map<String, String> propertyNames, Config config) {
        try {
            for (FieldDescriptor descriptor : ConfigMapper.getFieldDescriptors(instance.getClass())) {
                Field field = descriptor.field;
                field.setAccessible(true);
                Type genericType = field.getGenericType();
                Class<?> fieldClass = field.getType();
                String configPropName = propertyNames.remove(descriptor.name);
                if (configPropName == null) {
                    if (!Named.class.isAssignableFrom(clazz) || field.getType() != String.class || name == null || !descriptor.name.equals("name")) continue;
                    if (descriptor.deprecated) {
                        LOGGER.warn("{}.{} is deprecated!", (Object)path, (Object)name);
                    }
                    field.set(instance, name);
                    continue;
                }
                Object value = this.getValue(instance.getClass(), genericType, fieldClass, config, this.toPath(path, name), configPropName);
                if (value == null) continue;
                if (descriptor.deprecated) {
                    LOGGER.warn("{}.{} is deprecated!", (Object)path, (Object)name);
                }
                field.set(instance, value);
            }
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException(instance.getClass().getName() + " fields are not accessible, they must be for use as a bean", e);
        }
    }

    protected Object getValue(Class<?> beanClass, Type parameterType, Class<?> parameterClass, Config config, String configPath, String configPropName) {
        if (parameterClass == Boolean.class || parameterClass == Boolean.TYPE) {
            try {
                return config.getBoolean(configPropName);
            }
            catch (ConfigException.WrongType e) {
                return Boolean.parseBoolean(config.getString(configPropName));
            }
        }
        if (parameterClass == Integer.class || parameterClass == Integer.TYPE) {
            try {
                return config.getInt(configPropName);
            }
            catch (ConfigException.WrongType e) {
                try {
                    return Integer.parseInt(config.getString(configPropName));
                }
                catch (NumberFormatException e1) {
                    throw e;
                }
            }
        }
        if (parameterClass == Double.class || parameterClass == Double.TYPE) {
            try {
                return config.getDouble(configPropName);
            }
            catch (ConfigException.WrongType e) {
                try {
                    return Double.parseDouble(config.getString(configPropName));
                }
                catch (NumberFormatException e1) {
                    throw e;
                }
            }
        }
        if (parameterClass == Long.class || parameterClass == Long.TYPE) {
            try {
                return config.getLong(configPropName);
            }
            catch (ConfigException.WrongType e) {
                try {
                    return Long.parseLong(config.getString(configPropName));
                }
                catch (NumberFormatException e1) {
                    throw e;
                }
            }
        }
        if (parameterClass == String.class) {
            return config.getString(configPropName);
        }
        if (parameterClass == Duration.class) {
            return config.getDuration(configPropName);
        }
        if (parameterClass == MemorySize.class) {
            ConfigMemorySize size = config.getMemorySize(configPropName);
            return new MemorySize(size.toBytes());
        }
        if (parameterClass == Object.class) {
            return config.getAnyRef(configPropName);
        }
        if (parameterClass == List.class || parameterClass == Collection.class) {
            return this.getListValue(beanClass, parameterType, parameterClass, config, configPath, configPropName);
        }
        if (parameterClass == Set.class) {
            return this.getSetValue(beanClass, parameterType, parameterClass, config, configPath, configPropName);
        }
        if (parameterClass == Map.class) {
            return this.getMapValue(beanClass, parameterType, parameterClass, config, configPath, configPropName);
        }
        if (parameterClass == Config.class) {
            return config.getConfig(configPropName);
        }
        if (parameterClass == ConfigObject.class) {
            return config.getObject(configPropName);
        }
        if (parameterClass == ConfigValue.class) {
            return config.getValue(configPropName);
        }
        if (parameterClass == ConfigList.class) {
            return config.getList(configPropName);
        }
        if (parameterClass == Class.class) {
            String className = config.getString(configPropName);
            try {
                return this.classLoader.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Failed to load class: " + className);
            }
        }
        if (parameterClass.isEnum()) {
            String value = config.getString(configPropName);
            String enumName = value.replace("-", "_").toUpperCase();
            Object enumValue = Enum.valueOf(parameterClass, enumName);
            try {
                Deprecated deprecated = ((Enum)enumValue).getDeclaringClass().getField(enumName).getAnnotation(Deprecated.class);
                if (deprecated != null) {
                    LOGGER.warn("{}.{} = {} is deprecated!", new Object[]{configPath, configPropName, value});
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            return enumValue;
        }
        return this.map(config.getConfig(configPropName), configPath, configPropName, parameterClass);
    }

    protected Map getMapValue(Class<?> beanClass, Type parameterType, Class<?> parameterClass, Config config, String configPath, String configPropName) {
        Type[] typeArgs = ((ParameterizedType)parameterType).getActualTypeArguments();
        Type keyType = typeArgs[0];
        Type valueType = typeArgs[1];
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        Config childConfig = config.getConfig(configPropName);
        Class valueClass = (Class)(valueType instanceof ParameterizedType ? ((ParameterizedType)valueType).getRawType() : valueType);
        for (String key : config.getObject(configPropName).unwrapped().keySet()) {
            Object value = this.getValue(Map.class, valueType, valueClass, childConfig, this.toPath(configPath, configPropName), key);
            map.put(this.getKeyValue(keyType, key), value);
        }
        return map;
    }

    protected Object getKeyValue(Type keyType, String key) {
        if (keyType == Boolean.class || keyType == Boolean.TYPE) {
            return Boolean.parseBoolean(key);
        }
        if (keyType == Integer.class || keyType == Integer.TYPE) {
            return Integer.parseInt(key);
        }
        if (keyType == Double.class || keyType == Double.TYPE) {
            return Double.parseDouble(key);
        }
        if (keyType == Long.class || keyType == Long.TYPE) {
            return Long.parseLong(key);
        }
        if (keyType == String.class) {
            return key;
        }
        throw new ConfigurationException("Invalid map key type: " + keyType);
    }

    protected Object getSetValue(Class<?> beanClass, Type parameterType, Class<?> parameterClass, Config config, String configPath, String configPropName) {
        return new HashSet((List)this.getListValue(beanClass, parameterType, parameterClass, config, configPath, configPropName));
    }

    protected Object getListValue(Class<?> beanClass, Type parameterType, Class<?> parameterClass, Config config, String configPath, String configPropName) {
        Type elementType = ((ParameterizedType)parameterType).getActualTypeArguments()[0];
        if (elementType instanceof ParameterizedType) {
            elementType = ((ParameterizedType)elementType).getRawType();
        }
        if (elementType == Boolean.class) {
            try {
                return config.getBooleanList(configPropName);
            }
            catch (ConfigException.WrongType e) {
                return config.getStringList(configPropName).stream().map(Boolean::parseBoolean).collect(Collectors.toList());
            }
        }
        if (elementType == Integer.class) {
            try {
                return config.getIntList(configPropName);
            }
            catch (ConfigException.WrongType e) {
                return config.getStringList(configPropName).stream().map(value -> {
                    try {
                        return Integer.parseInt(value);
                    }
                    catch (NumberFormatException e2) {
                        throw e;
                    }
                }).collect(Collectors.toList());
            }
        }
        if (elementType == Double.class) {
            try {
                return config.getDoubleList(configPropName);
            }
            catch (ConfigException.WrongType e) {
                return config.getStringList(configPropName).stream().map(value -> {
                    try {
                        return Double.parseDouble(value);
                    }
                    catch (NumberFormatException e2) {
                        throw e;
                    }
                }).collect(Collectors.toList());
            }
        }
        if (elementType == Long.class) {
            try {
                return config.getLongList(configPropName);
            }
            catch (ConfigException.WrongType e) {
                return config.getStringList(configPropName).stream().map(value -> {
                    try {
                        return Long.parseLong(value);
                    }
                    catch (NumberFormatException e2) {
                        throw e;
                    }
                }).collect(Collectors.toList());
            }
        }
        if (elementType == String.class) {
            return config.getStringList(configPropName);
        }
        if (elementType == Duration.class) {
            return config.getDurationList(configPropName);
        }
        if (elementType == MemorySize.class) {
            List sizes = config.getMemorySizeList(configPropName);
            return sizes.stream().map(size -> new MemorySize(size.toBytes())).collect(Collectors.toList());
        }
        if (elementType == Class.class) {
            return config.getStringList(configPropName).stream().map(className -> {
                try {
                    return this.classLoader.loadClass((String)className);
                }
                catch (ClassNotFoundException e) {
                    throw new ConfigurationException("Failed to load class: " + className);
                }
            }).collect(Collectors.toList());
        }
        if (elementType == Object.class) {
            return config.getAnyRefList(configPropName);
        }
        if (((Class)elementType).isEnum()) {
            List enumValues = config.getEnumList((Class)elementType, configPropName);
            return enumValues;
        }
        ArrayList beanList = new ArrayList();
        List configList = config.getConfigList(configPropName);
        int i = 0;
        for (Config listMember : configList) {
            beanList.add(this.map(listMember, this.toPath(configPath, configPropName), String.valueOf(i), (Class)elementType));
        }
        return beanList;
    }

    protected String toPath(String path, String name) {
        return path != null ? String.format("%s.%s", path, name) : name;
    }

    protected static boolean isSimpleType(Class<?> parameterClass) {
        return parameterClass == Boolean.class || parameterClass == Boolean.TYPE || parameterClass == Integer.class || parameterClass == Integer.TYPE || parameterClass == Double.class || parameterClass == Double.TYPE || parameterClass == Long.class || parameterClass == Long.TYPE || parameterClass == String.class || parameterClass == Duration.class || parameterClass == MemorySize.class || parameterClass == List.class || parameterClass == Map.class || parameterClass == Class.class;
    }

    protected static String toCamelCase(String originalName) {
        String[] words = originalName.split("-+");
        if (words.length > 1) {
            LOGGER.warn("Kebab case config name '" + originalName + "' is deprecated!");
            StringBuilder nameBuilder = new StringBuilder(originalName.length());
            for (String word : words) {
                if (nameBuilder.length() == 0) {
                    nameBuilder.append(word);
                    continue;
                }
                nameBuilder.append(word.substring(0, 1).toUpperCase());
                nameBuilder.append(word.substring(1));
            }
            return nameBuilder.toString();
        }
        return originalName;
    }

    protected static String toSetterName(String name) {
        return "set" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected static Collection<SetterDescriptor> getSetterDescriptors(Class<?> clazz) {
        HashMap descriptors = Maps.newHashMap();
        for (Method method : clazz.getMethods()) {
            SetterDescriptor descriptor;
            String name = method.getName();
            if (method.getParameterTypes().length != 1 || name.length() <= 3 || !name.substring(0, 3).equals("set") || name.charAt(3) < 'A' || name.charAt(3) > 'Z') continue;
            name = method.getName().substring(3);
            String string = name = name.length() > 1 ? name.substring(0, 1).toLowerCase() + name.substring(1) : name.toLowerCase();
            if (name.endsWith("Config")) {
                name = name.substring(0, name.length() - "Config".length());
            }
            if ((descriptor = (SetterDescriptor)descriptors.get(name)) != null) {
                Class<?> type = method.getParameterTypes()[0];
                if (!ConfigMapper.isSimpleType(type)) continue;
                descriptors.put(name, new SetterDescriptor(name, method));
                continue;
            }
            descriptors.put(name, new SetterDescriptor(name, method));
        }
        return descriptors.values();
    }

    protected static Collection<FieldDescriptor> getFieldDescriptors(Class<?> type) {
        HashMap descriptors = Maps.newHashMap();
        for (Class<?> clazz = type; clazz != Object.class; clazz = clazz.getSuperclass()) {
            for (Field field : clazz.getDeclaredFields()) {
                Method method;
                if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers()) || (method = (Method)Stream.of(clazz.getMethods()).filter(m -> m.getName().equals(ConfigMapper.toSetterName(field.getName()))).findFirst().orElse(null)) != null) continue;
                String name = field.getName();
                if (name.endsWith("Config")) {
                    name = name.substring(0, name.length() - "Config".length());
                }
                descriptors.putIfAbsent(name, new FieldDescriptor(name, field));
            }
        }
        return Lists.newArrayList(descriptors.values());
    }

    protected static class FieldDescriptor {
        private final String name;
        private final Field field;
        private final boolean deprecated;

        FieldDescriptor(String name, Field field) {
            this.name = name;
            this.field = field;
            this.deprecated = field.getAnnotation(Deprecated.class) != null;
        }
    }

    protected static class SetterDescriptor {
        private final String name;
        private final Method setter;
        private final boolean deprecated;

        SetterDescriptor(String name, Method setter) {
            this.name = name;
            this.setter = setter;
            this.deprecated = setter.getAnnotation(Deprecated.class) != null;
        }
    }
}

