/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack;

import io.zeebe.msgpack.Recyclable;
import io.zeebe.msgpack.spec.MsgPackReader;
import io.zeebe.msgpack.spec.MsgPackWriter;
import io.zeebe.msgpack.value.ObjectValue;
import io.zeebe.util.buffer.BufferReader;
import io.zeebe.util.buffer.BufferWriter;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;

public class UnpackedObject
extends ObjectValue
implements Recyclable,
BufferReader,
BufferWriter {
    protected final MsgPackReader reader = new MsgPackReader();
    protected final MsgPackWriter writer = new MsgPackWriter();

    public void wrap(DirectBuffer buff) {
        this.wrap(buff, 0, buff.capacity());
    }

    public void wrap(DirectBuffer buff, int offset, int length) {
        this.reader.wrap(buff, offset, length);
        try {
            this.read(this.reader);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not deserialize object. Deserialization stuck at offset " + this.reader.getOffset() + " of length " + length, e);
        }
    }

    public int getLength() {
        return this.getEncodedLength();
    }

    public void write(MutableDirectBuffer buffer, int offset) {
        this.writer.wrap(buffer, offset);
        this.write(this.writer);
    }
}

