/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.value;

import io.zeebe.msgpack.spec.MsgPackReader;
import io.zeebe.msgpack.spec.MsgPackWriter;
import io.zeebe.msgpack.value.BaseValue;
import java.util.Objects;

public class IntegerValue
extends BaseValue {
    protected int value;

    public IntegerValue() {
        this(0);
    }

    public IntegerValue(int initialValue) {
        this.value = initialValue;
    }

    public void setValue(int val) {
        this.value = val;
    }

    public int getValue() {
        return this.value;
    }

    @Override
    public void reset() {
        this.value = 0;
    }

    @Override
    public void writeJSON(StringBuilder builder) {
        builder.append(this.value);
    }

    @Override
    public void write(MsgPackWriter writer) {
        writer.writeInteger((long)this.value);
    }

    @Override
    public void read(MsgPackReader reader) {
        long longValue = reader.readInteger();
        if (longValue < Integer.MIN_VALUE || longValue > Integer.MAX_VALUE) {
            throw new RuntimeException(String.format("Value doesn't fit into an integer: %s.", longValue));
        }
        this.value = (int)longValue;
    }

    @Override
    public int getEncodedLength() {
        return MsgPackWriter.getEncodedLongValueLength((long)this.value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof IntegerValue)) {
            return false;
        }
        IntegerValue that = (IntegerValue)o;
        return this.getValue() == that.getValue();
    }

    public int hashCode() {
        return Objects.hash(this.getValue());
    }
}

