/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.model.bpmn.builder;

import io.zeebe.model.bpmn.AssociationDirection;
import io.zeebe.model.bpmn.BpmnModelException;
import io.zeebe.model.bpmn.BpmnModelInstance;
import io.zeebe.model.bpmn.builder.AbstractActivityBuilder;
import io.zeebe.model.bpmn.builder.AbstractExclusiveGatewayBuilder;
import io.zeebe.model.bpmn.builder.AbstractFlowElementBuilder;
import io.zeebe.model.bpmn.builder.AbstractGatewayBuilder;
import io.zeebe.model.bpmn.builder.BusinessRuleTaskBuilder;
import io.zeebe.model.bpmn.builder.CallActivityBuilder;
import io.zeebe.model.bpmn.builder.EndEventBuilder;
import io.zeebe.model.bpmn.builder.EventBasedGatewayBuilder;
import io.zeebe.model.bpmn.builder.ExclusiveGatewayBuilder;
import io.zeebe.model.bpmn.builder.InclusiveGatewayBuilder;
import io.zeebe.model.bpmn.builder.IntermediateCatchEventBuilder;
import io.zeebe.model.bpmn.builder.IntermediateThrowEventBuilder;
import io.zeebe.model.bpmn.builder.ManualTaskBuilder;
import io.zeebe.model.bpmn.builder.ParallelGatewayBuilder;
import io.zeebe.model.bpmn.builder.ReceiveTaskBuilder;
import io.zeebe.model.bpmn.builder.ScriptTaskBuilder;
import io.zeebe.model.bpmn.builder.SendTaskBuilder;
import io.zeebe.model.bpmn.builder.SequenceFlowBuilder;
import io.zeebe.model.bpmn.builder.ServiceTaskBuilder;
import io.zeebe.model.bpmn.builder.SubProcessBuilder;
import io.zeebe.model.bpmn.builder.TransactionBuilder;
import io.zeebe.model.bpmn.builder.UserTaskBuilder;
import io.zeebe.model.bpmn.instance.Activity;
import io.zeebe.model.bpmn.instance.Association;
import io.zeebe.model.bpmn.instance.BaseElement;
import io.zeebe.model.bpmn.instance.BoundaryEvent;
import io.zeebe.model.bpmn.instance.BusinessRuleTask;
import io.zeebe.model.bpmn.instance.CallActivity;
import io.zeebe.model.bpmn.instance.CompensateEventDefinition;
import io.zeebe.model.bpmn.instance.ConditionExpression;
import io.zeebe.model.bpmn.instance.EndEvent;
import io.zeebe.model.bpmn.instance.EventBasedGateway;
import io.zeebe.model.bpmn.instance.EventDefinition;
import io.zeebe.model.bpmn.instance.ExclusiveGateway;
import io.zeebe.model.bpmn.instance.FlowNode;
import io.zeebe.model.bpmn.instance.Gateway;
import io.zeebe.model.bpmn.instance.InclusiveGateway;
import io.zeebe.model.bpmn.instance.IntermediateCatchEvent;
import io.zeebe.model.bpmn.instance.IntermediateThrowEvent;
import io.zeebe.model.bpmn.instance.ManualTask;
import io.zeebe.model.bpmn.instance.ParallelGateway;
import io.zeebe.model.bpmn.instance.ReceiveTask;
import io.zeebe.model.bpmn.instance.ScriptTask;
import io.zeebe.model.bpmn.instance.SendTask;
import io.zeebe.model.bpmn.instance.SequenceFlow;
import io.zeebe.model.bpmn.instance.ServiceTask;
import io.zeebe.model.bpmn.instance.SubProcess;
import io.zeebe.model.bpmn.instance.Transaction;
import io.zeebe.model.bpmn.instance.UserTask;
import io.zeebe.model.bpmn.instance.bpmndi.BpmnShape;
import java.util.function.Consumer;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;

public abstract class AbstractFlowNodeBuilder<B extends AbstractFlowNodeBuilder<B, E>, E extends FlowNode>
extends AbstractFlowElementBuilder<B, E> {
    private SequenceFlowBuilder currentSequenceFlowBuilder;
    protected boolean compensationStarted;
    protected BoundaryEvent compensateBoundaryEvent;

    protected AbstractFlowNodeBuilder(BpmnModelInstance modelInstance, E element, Class<?> selfType) {
        super(modelInstance, element, selfType);
    }

    protected SequenceFlowBuilder getCurrentSequenceFlowBuilder() {
        if (this.currentSequenceFlowBuilder == null) {
            SequenceFlow sequenceFlow = this.createSibling(SequenceFlow.class);
            this.currentSequenceFlowBuilder = sequenceFlow.builder();
        }
        return this.currentSequenceFlowBuilder;
    }

    public B condition(String name, String condition) {
        if (name != null) {
            this.getCurrentSequenceFlowBuilder().name(name);
        }
        ConditionExpression conditionExpression = this.createInstance(ConditionExpression.class);
        conditionExpression.setTextContent(condition);
        this.getCurrentSequenceFlowBuilder().condition(conditionExpression);
        return (B)((AbstractFlowNodeBuilder)this.myself);
    }

    public B condition(String condition) {
        return this.condition(null, condition);
    }

    protected void connectTarget(FlowNode target) {
        if (this.isBoundaryEventWithStartedCompensation()) {
            if (target instanceof Activity) {
                ((Activity)target).setForCompensation(true);
            }
            this.connectTargetWithAssociation(target);
        } else {
            if (this.isCompensationHandler()) {
                throw new BpmnModelException("Only single compensation handler allowed. Call compensationDone() to continue main flow.");
            }
            this.connectTargetWithSequenceFlow(target);
        }
    }

    protected void connectTargetWithSequenceFlow(FlowNode target) {
        ((SequenceFlowBuilder)this.getCurrentSequenceFlowBuilder().from((FlowNode)this.element)).to(target);
        SequenceFlow sequenceFlow = (SequenceFlow)this.getCurrentSequenceFlowBuilder().getElement();
        this.createEdge(sequenceFlow);
        this.currentSequenceFlowBuilder = null;
    }

    protected void connectTargetWithAssociation(FlowNode target) {
        Association association = (Association)this.modelInstance.newInstance(Association.class);
        association.setTarget(target);
        association.setSource((BaseElement)this.element);
        association.setAssociationDirection(AssociationDirection.One);
        ((FlowNode)this.element).getParentElement().addChildElement((ModelElementInstance)association);
        this.createEdge(association);
    }

    public AbstractFlowNodeBuilder compensationDone() {
        if (this.compensateBoundaryEvent != null) {
            return this.compensateBoundaryEvent.getAttachedTo().builder();
        }
        throw new BpmnModelException("No compensation in progress. Call compensationStart() first.");
    }

    public B sequenceFlowId(String sequenceFlowId) {
        this.getCurrentSequenceFlowBuilder().id(sequenceFlowId);
        return (B)((AbstractFlowNodeBuilder)this.myself);
    }

    private <T extends FlowNode> T createTarget(Class<T> typeClass) {
        return this.createTarget(typeClass, null);
    }

    protected <T extends FlowNode> T createTarget(Class<T> typeClass, String identifier) {
        FlowNode target = (FlowNode)this.createSibling(typeClass, identifier);
        BpmnShape targetBpmnShape = this.createBpmnShape(target);
        this.setCoordinates(targetBpmnShape);
        this.connectTarget(target);
        this.resizeSubProcess(targetBpmnShape);
        return (T)target;
    }

    protected <T extends AbstractFlowNodeBuilder, F extends FlowNode> T createTargetBuilder(Class<F> typeClass) {
        return this.createTargetBuilder(typeClass, null);
    }

    protected <T extends AbstractFlowNodeBuilder, F extends FlowNode> T createTargetBuilder(Class<F> typeClass, String id) {
        AbstractFlowNodeBuilder builder = this.createTarget(typeClass, id).builder();
        if (this.compensationStarted) {
            builder.compensateBoundaryEvent = this.compensateBoundaryEvent;
        }
        return (T)builder;
    }

    public ServiceTaskBuilder serviceTask() {
        return (ServiceTaskBuilder)this.createTargetBuilder(ServiceTask.class);
    }

    public ServiceTaskBuilder serviceTask(String id) {
        return (ServiceTaskBuilder)this.createTargetBuilder(ServiceTask.class, id);
    }

    public ServiceTaskBuilder serviceTask(String id, Consumer<ServiceTaskBuilder> consumer) {
        ServiceTaskBuilder builder = (ServiceTaskBuilder)this.createTargetBuilder(ServiceTask.class, id);
        consumer.accept(builder);
        return builder;
    }

    public SendTaskBuilder sendTask() {
        return (SendTaskBuilder)this.createTargetBuilder(SendTask.class);
    }

    public SendTaskBuilder sendTask(String id) {
        return (SendTaskBuilder)this.createTargetBuilder(SendTask.class, id);
    }

    public UserTaskBuilder userTask() {
        return (UserTaskBuilder)this.createTargetBuilder(UserTask.class);
    }

    public UserTaskBuilder userTask(String id) {
        return (UserTaskBuilder)this.createTargetBuilder(UserTask.class, id);
    }

    public BusinessRuleTaskBuilder businessRuleTask() {
        return (BusinessRuleTaskBuilder)this.createTargetBuilder(BusinessRuleTask.class);
    }

    public BusinessRuleTaskBuilder businessRuleTask(String id) {
        return (BusinessRuleTaskBuilder)this.createTargetBuilder(BusinessRuleTask.class, id);
    }

    public ScriptTaskBuilder scriptTask() {
        return (ScriptTaskBuilder)this.createTargetBuilder(ScriptTask.class);
    }

    public ScriptTaskBuilder scriptTask(String id) {
        return (ScriptTaskBuilder)this.createTargetBuilder(ScriptTask.class, id);
    }

    public ReceiveTaskBuilder receiveTask() {
        return (ReceiveTaskBuilder)this.createTargetBuilder(ReceiveTask.class);
    }

    public ReceiveTaskBuilder receiveTask(String id) {
        return (ReceiveTaskBuilder)this.createTargetBuilder(ReceiveTask.class, id);
    }

    public ManualTaskBuilder manualTask() {
        return (ManualTaskBuilder)this.createTargetBuilder(ManualTask.class);
    }

    public ManualTaskBuilder manualTask(String id) {
        return (ManualTaskBuilder)this.createTargetBuilder(ManualTask.class, id);
    }

    public EndEventBuilder endEvent() {
        return this.createTarget(EndEvent.class).builder();
    }

    public EndEventBuilder endEvent(String id) {
        return this.createTarget(EndEvent.class, id).builder();
    }

    public ParallelGatewayBuilder parallelGateway() {
        return this.createTarget(ParallelGateway.class).builder();
    }

    public ParallelGatewayBuilder parallelGateway(String id) {
        return this.createTarget(ParallelGateway.class, id).builder();
    }

    public ExclusiveGatewayBuilder exclusiveGateway() {
        return this.createTarget(ExclusiveGateway.class).builder();
    }

    public InclusiveGatewayBuilder inclusiveGateway() {
        return this.createTarget(InclusiveGateway.class).builder();
    }

    public EventBasedGatewayBuilder eventBasedGateway() {
        return this.createTarget(EventBasedGateway.class).builder();
    }

    public EventBasedGatewayBuilder eventBasedGateway(String id) {
        return this.createTarget(EventBasedGateway.class, id).builder();
    }

    public ExclusiveGatewayBuilder exclusiveGateway(String id) {
        return this.createTarget(ExclusiveGateway.class, id).builder();
    }

    public InclusiveGatewayBuilder inclusiveGateway(String id) {
        return this.createTarget(InclusiveGateway.class, id).builder();
    }

    public IntermediateCatchEventBuilder intermediateCatchEvent() {
        return this.createTarget(IntermediateCatchEvent.class).builder();
    }

    public IntermediateCatchEventBuilder intermediateCatchEvent(String id) {
        return this.createTarget(IntermediateCatchEvent.class, id).builder();
    }

    public IntermediateCatchEventBuilder intermediateCatchEvent(String id, Consumer<IntermediateCatchEventBuilder> builderConsumer) {
        IntermediateCatchEventBuilder builder = this.createTarget(IntermediateCatchEvent.class, id).builder();
        builderConsumer.accept(builder);
        return builder;
    }

    public IntermediateThrowEventBuilder intermediateThrowEvent() {
        return this.createTarget(IntermediateThrowEvent.class).builder();
    }

    public IntermediateThrowEventBuilder intermediateThrowEvent(String id) {
        return this.createTarget(IntermediateThrowEvent.class, id).builder();
    }

    public CallActivityBuilder callActivity() {
        return this.createTarget(CallActivity.class).builder();
    }

    public CallActivityBuilder callActivity(String id) {
        return this.createTarget(CallActivity.class, id).builder();
    }

    public SubProcessBuilder subProcess() {
        return this.createTarget(SubProcess.class).builder();
    }

    public SubProcessBuilder subProcess(String id) {
        return this.createTarget(SubProcess.class, id).builder();
    }

    public SubProcessBuilder subProcess(String id, Consumer<SubProcessBuilder> consumer) {
        SubProcessBuilder builder = this.createTarget(SubProcess.class, id).builder();
        consumer.accept(builder);
        return builder;
    }

    public TransactionBuilder transaction() {
        Transaction transaction = this.createTarget(Transaction.class);
        return new TransactionBuilder(this.modelInstance, transaction);
    }

    public TransactionBuilder transaction(String id) {
        Transaction transaction = this.createTarget(Transaction.class, id);
        return new TransactionBuilder(this.modelInstance, transaction);
    }

    private <T extends Gateway> T findLastGateway(Class<T> gatewayType) {
        FlowNode lastGateway = (FlowNode)this.element;
        try {
            while (!gatewayType.isAssignableFrom((lastGateway = lastGateway.getPreviousNodes().singleResult()).getClass())) {
            }
            return (T)((Gateway)gatewayType.cast(lastGateway));
        }
        catch (BpmnModelException e) {
            throw new BpmnModelException("Unable to determine an unique previous gateway of " + lastGateway.getId(), (Throwable)((Object)e));
        }
    }

    public AbstractGatewayBuilder<?, ?> moveToLastGateway() {
        return this.findLastGateway(Gateway.class).builder();
    }

    public AbstractExclusiveGatewayBuilder<?> moveToLastExclusiveGateway() {
        return this.findLastGateway(ExclusiveGateway.class).builder();
    }

    public AbstractFlowNodeBuilder<?, ?> moveToNode(String identifier) {
        ModelElementInstance instance = this.modelInstance.getModelElementById(identifier);
        if (instance instanceof FlowNode) {
            return ((FlowNode)instance).builder();
        }
        throw new BpmnModelException("Flow node not found for id " + identifier);
    }

    public <T extends AbstractActivityBuilder<?, ?>> T moveToActivity(String identifier) {
        ModelElementInstance instance = this.modelInstance.getModelElementById(identifier);
        if (instance instanceof Activity) {
            return (T)((AbstractActivityBuilder)((Activity)instance).builder());
        }
        throw new BpmnModelException("Activity not found for id " + identifier);
    }

    public AbstractFlowNodeBuilder<?, ?> connectTo(String identifier) {
        ModelElementInstance target = this.modelInstance.getModelElementById(identifier);
        if (target == null) {
            throw new BpmnModelException("Unable to connect " + ((FlowNode)this.element).getId() + " to element " + identifier + " cause it not exists.");
        }
        if (!(target instanceof FlowNode)) {
            throw new BpmnModelException("Unable to connect " + ((FlowNode)this.element).getId() + " to element " + identifier + " cause its not a flow node.");
        }
        FlowNode targetNode = (FlowNode)target;
        this.connectTarget(targetNode);
        return targetNode.builder();
    }

    public B compensationStart() {
        if (this.element instanceof BoundaryEvent) {
            BoundaryEvent boundaryEvent = (BoundaryEvent)this.element;
            for (EventDefinition eventDefinition : boundaryEvent.getEventDefinitions()) {
                if (!(eventDefinition instanceof CompensateEventDefinition)) continue;
                this.compensateBoundaryEvent = boundaryEvent;
                this.compensationStarted = true;
                return (B)((AbstractFlowNodeBuilder)this.myself);
            }
        }
        throw new BpmnModelException("Compensation can only be started on a boundary event with a compensation event definition");
    }

    protected boolean isBoundaryEventWithStartedCompensation() {
        return this.compensationStarted && this.compensateBoundaryEvent != null;
    }

    protected boolean isCompensationHandler() {
        return !this.compensationStarted && this.compensateBoundaryEvent != null;
    }
}

