/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.model.bpmn.builder;

import io.zeebe.model.bpmn.builder.AbstractEmbeddedSubProcessBuilder;
import io.zeebe.model.bpmn.builder.AbstractSubProcessBuilder;
import io.zeebe.model.bpmn.builder.EventSubProcessBuilder;
import io.zeebe.model.bpmn.builder.StartEventBuilder;
import io.zeebe.model.bpmn.instance.BaseElement;
import io.zeebe.model.bpmn.instance.StartEvent;
import io.zeebe.model.bpmn.instance.SubProcess;
import io.zeebe.model.bpmn.instance.bpmndi.BpmnShape;
import io.zeebe.model.bpmn.instance.dc.Bounds;

public class EmbeddedSubProcessBuilder
extends AbstractEmbeddedSubProcessBuilder<EmbeddedSubProcessBuilder, AbstractSubProcessBuilder<?>> {
    protected EmbeddedSubProcessBuilder(AbstractSubProcessBuilder subProcessBuilder) {
        super(subProcessBuilder, EmbeddedSubProcessBuilder.class);
    }

    public StartEventBuilder startEvent() {
        return this.startEvent(null);
    }

    public StartEventBuilder startEvent(String id) {
        StartEvent start = this.subProcessBuilder.createChild(StartEvent.class, id);
        BpmnShape startShape = this.subProcessBuilder.createBpmnShape(start);
        BpmnShape subProcessShape = this.subProcessBuilder.findBpmnShape((BaseElement)this.subProcessBuilder.getElement());
        if (subProcessShape != null) {
            Bounds subProcessBounds = subProcessShape.getBounds();
            Bounds startBounds = startShape.getBounds();
            double subProcessX = subProcessBounds.getX();
            double subProcessY = subProcessBounds.getY();
            double subProcessHeight = subProcessBounds.getHeight();
            double startHeight = startBounds.getHeight();
            startBounds.setX(subProcessX + 50.0);
            startBounds.setY(subProcessY + subProcessHeight / 2.0 - startHeight / 2.0);
        }
        return start.builder();
    }

    public EventSubProcessBuilder eventSubProcess() {
        return this.eventSubProcess(null);
    }

    public EventSubProcessBuilder eventSubProcess(String id) {
        SubProcess subProcess = this.subProcessBuilder.createChild(SubProcess.class, id);
        subProcess.setTriggeredByEvent(true);
        BpmnShape targetBpmnShape = this.subProcessBuilder.createBpmnShape(subProcess);
        this.setCoordinates(targetBpmnShape);
        this.subProcessBuilder.resizeSubProcess(targetBpmnShape);
        EventSubProcessBuilder eventSubProcessBuilder = new EventSubProcessBuilder(this.subProcessBuilder.modelInstance, subProcess);
        return eventSubProcessBuilder;
    }

    protected void setCoordinates(BpmnShape targetBpmnShape) {
        SubProcess eventSubProcess = (SubProcess)targetBpmnShape.getBpmnElement();
        SubProcess parentSubProcess = (SubProcess)eventSubProcess.getParentElement();
        BpmnShape parentBpmnShape = this.subProcessBuilder.findBpmnShape(parentSubProcess);
        Bounds targetBounds = targetBpmnShape.getBounds();
        Bounds parentBounds = parentBpmnShape.getBounds();
        double ycoord = parentBounds.getHeight() + parentBounds.getY();
        double xcoord = parentBounds.getWidth() / 2.0 - targetBounds.getWidth() / 2.0 + parentBounds.getX();
        if (xcoord - parentBounds.getX() < 50.0) {
            xcoord = 50.0 + parentBounds.getX();
        }
        targetBounds.setY(ycoord);
        targetBounds.setX(xcoord);
    }
}

