/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.model.bpmn.traversal;

import io.zeebe.model.bpmn.BpmnModelInstance;
import io.zeebe.model.bpmn.impl.BpmnModelInstanceImpl;
import io.zeebe.model.bpmn.instance.BpmnModelElementInstance;
import io.zeebe.model.bpmn.instance.Definitions;
import io.zeebe.model.bpmn.traversal.ModelElementVisitor;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import org.camunda.bpm.model.xml.impl.ModelInstanceImpl;
import org.camunda.bpm.model.xml.impl.util.ModelUtil;

public class ModelWalker {
    private BpmnModelInstanceImpl modelInstance;
    private Deque<BpmnModelElementInstance> elementsToVisit = new LinkedList<BpmnModelElementInstance>();

    public ModelWalker(BpmnModelInstance modelInstance) {
        this.modelInstance = (BpmnModelInstanceImpl)modelInstance;
    }

    public void walk(ModelElementVisitor visitor) {
        BpmnModelElementInstance currentElement;
        Definitions rootElement = this.modelInstance.getDefinitions();
        this.elementsToVisit.add(rootElement);
        while ((currentElement = this.elementsToVisit.poll()) != null) {
            visitor.visit(currentElement);
            Collection<BpmnModelElementInstance> children = this.getChildElements(currentElement);
            children.forEach(c -> this.elementsToVisit.addFirst((BpmnModelElementInstance)c));
        }
    }

    private Collection<BpmnModelElementInstance> getChildElements(BpmnModelElementInstance element) {
        return ModelUtil.getModelElementCollection((Collection)element.getDomElement().getChildElements(), (ModelInstanceImpl)this.modelInstance);
    }
}

