/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.model.bpmn.util.time;

import io.zeebe.model.bpmn.util.time.Interval;
import io.zeebe.model.bpmn.util.time.Timer;
import java.time.Duration;
import java.time.Period;
import java.time.ZonedDateTime;

public class TimeDateTimer
implements Timer {
    private final Interval interval;

    public TimeDateTimer(Interval interval) {
        this.interval = interval;
    }

    public static TimeDateTimer parse(String timeDate) {
        ZonedDateTime dateTime = ZonedDateTime.parse(timeDate);
        Interval interval = new Interval(Period.ZERO, Duration.ofMillis(dateTime.toInstant().toEpochMilli()));
        return new TimeDateTimer(interval);
    }

    @Override
    public long getDueDate(long fromEpochMillis) {
        return this.getInterval().toEpochMilli(0L);
    }

    @Override
    public Interval getInterval() {
        return this.interval;
    }

    @Override
    public int getRepetitions() {
        return 1;
    }
}

