/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.model.bpmn.validation;

import io.zeebe.model.bpmn.instance.BpmnModelElementInstance;
import io.zeebe.model.bpmn.traversal.TypeHierarchyVisitor;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.camunda.bpm.model.xml.impl.validation.ValidationResultsCollectorImpl;
import org.camunda.bpm.model.xml.instance.ModelElementInstance;
import org.camunda.bpm.model.xml.type.ModelElementType;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;
import org.camunda.bpm.model.xml.validation.ValidationResults;

public class ValidationVisitor
extends TypeHierarchyVisitor {
    private final Map<Class<?>, ModelElementValidator<?>> validators = new HashMap();
    private ValidationResultsCollectorImpl resultCollector;

    public ValidationVisitor(Collection<ModelElementValidator<?>> validators) {
        validators.forEach(v -> this.validators.put(v.getElementType(), (ModelElementValidator<?>)v));
        this.resultCollector = new ValidationResultsCollectorImpl();
    }

    @Override
    protected void visit(ModelElementType implementedType, BpmnModelElementInstance instance) {
        this.resultCollector.setCurrentElement((ModelElementInstance)instance);
        ModelElementValidator<?> validator = this.validators.get(implementedType.getInstanceType());
        if (validator != null) {
            validator.validate((ModelElementInstance)instance, (ValidationResultCollector)this.resultCollector);
        }
    }

    public void reset() {
        this.resultCollector = new ValidationResultsCollectorImpl();
    }

    public ValidationResults getValidationResult() {
        return this.resultCollector.getResults();
    }
}

