/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.model.bpmn.validation.zeebe;

import io.zeebe.model.bpmn.instance.Activity;
import io.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.zeebe.model.bpmn.util.ModelUtil;
import java.util.HashSet;
import java.util.Set;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class ActivityValidator
implements ModelElementValidator<Activity> {
    public Class<Activity> getElementType() {
        return Activity.class;
    }

    public void validate(Activity element, ValidationResultCollector validationResultCollector) {
        HashSet messageNames = new HashSet();
        ModelUtil.getActivityMessageBoundaryEvents(element).forEach(event -> this.validateMessageTriggerUniqueness(validationResultCollector, messageNames, (MessageEventDefinition)event));
    }

    private void validateMessageTriggerUniqueness(ValidationResultCollector validationResultCollector, Set<String> boundaryEventMessageNames, MessageEventDefinition messageDefinition) {
        String name = messageDefinition.getMessage().getName();
        boolean didNotContain = boundaryEventMessageNames.add(name);
        if (!didNotContain) {
            validationResultCollector.addError(0, String.format("Cannot have two message catch boundary events with the same name: %s", name));
        }
    }
}

