/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.model.bpmn.validation.zeebe;

import io.zeebe.model.bpmn.instance.ExtensionElements;
import io.zeebe.model.bpmn.instance.IntermediateCatchEvent;
import io.zeebe.model.bpmn.instance.Message;
import io.zeebe.model.bpmn.instance.MessageEventDefinition;
import io.zeebe.model.bpmn.instance.Process;
import io.zeebe.model.bpmn.instance.ReceiveTask;
import io.zeebe.model.bpmn.instance.StartEvent;
import io.zeebe.model.bpmn.instance.zeebe.ZeebeSubscription;
import java.util.Collection;
import java.util.stream.Collectors;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class MessageValidator
implements ModelElementValidator<Message> {
    public Class<Message> getElementType() {
        return Message.class;
    }

    public void validate(Message element, ValidationResultCollector validationResultCollector) {
        if (this.isReferedByCatchEvent(element) || this.isReferedByReceiveTask(element)) {
            ExtensionElements extensionElements;
            if (element.getName() == null || element.getName().isEmpty()) {
                validationResultCollector.addError(0, "Name must be present and not empty");
            }
            if ((extensionElements = element.getExtensionElements()) == null || extensionElements.getChildElementsByType(ZeebeSubscription.class).size() != 1) {
                validationResultCollector.addError(0, "Must have exactly one zeebe:subscription extension element");
            }
        } else {
            this.validateIfReferredByStartEvent(element, validationResultCollector);
        }
    }

    private void validateIfReferredByStartEvent(Message element, ValidationResultCollector validationResultCollector) {
        Collection startEvents = element.getParentElement().getChildElementsByType(Process.class).stream().flatMap(p -> p.getChildElementsByType(StartEvent.class).stream()).collect(Collectors.toList());
        long numReferredStartEvents = startEvents.stream().flatMap(i -> i.getEventDefinitions().stream()).filter(e -> e instanceof MessageEventDefinition && ((MessageEventDefinition)e).getMessage() == element).count();
        if (numReferredStartEvents > 1L) {
            validationResultCollector.addError(0, "A message cannot be referred by more than one start event");
        } else if (numReferredStartEvents == 1L && (element.getName() == null || element.getName().isEmpty())) {
            validationResultCollector.addError(0, "Name must be present and not empty");
        }
    }

    private boolean isReferedByCatchEvent(Message element) {
        Collection intermediateCatchEvents = element.getParentElement().getChildElementsByType(Process.class).stream().flatMap(p -> p.getChildElementsByType(IntermediateCatchEvent.class).stream()).collect(Collectors.toList());
        return intermediateCatchEvents.stream().flatMap(i -> i.getEventDefinitions().stream()).anyMatch(e -> e instanceof MessageEventDefinition && ((MessageEventDefinition)e).getMessage() == element);
    }

    private boolean isReferedByReceiveTask(Message element) {
        Collection receiveTasks = element.getParentElement().getChildElementsByType(Process.class).stream().flatMap(p -> p.getChildElementsByType(ReceiveTask.class).stream()).collect(Collectors.toList());
        return receiveTasks.stream().anyMatch(r -> r.getMessage() == element);
    }
}

