/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.model.bpmn.validation.zeebe;

import io.zeebe.model.bpmn.instance.TimeCycle;
import io.zeebe.model.bpmn.instance.TimeDate;
import io.zeebe.model.bpmn.instance.TimeDuration;
import io.zeebe.model.bpmn.instance.TimerEventDefinition;
import io.zeebe.model.bpmn.util.time.Interval;
import io.zeebe.model.bpmn.util.time.RepeatingInterval;
import io.zeebe.model.bpmn.util.time.TimeDateTimer;
import java.time.format.DateTimeParseException;
import org.camunda.bpm.model.xml.validation.ModelElementValidator;
import org.camunda.bpm.model.xml.validation.ValidationResultCollector;

public class TimerEventDefinitionValidator
implements ModelElementValidator<TimerEventDefinition> {
    public Class<TimerEventDefinition> getElementType() {
        return TimerEventDefinition.class;
    }

    public void validate(TimerEventDefinition element, ValidationResultCollector validationResultCollector) {
        TimeDuration timeDuration = element.getTimeDuration();
        TimeCycle timeCycle = element.getTimeCycle();
        TimeDate timeDate = element.getTimeDate();
        int definitionsCount = 0;
        if (timeDate != null) {
            this.validateTimeDate(element.getTimeDate(), validationResultCollector);
            ++definitionsCount;
        }
        if (timeDuration != null) {
            this.validateTimeDuration(validationResultCollector, timeDuration);
            ++definitionsCount;
        }
        if (timeCycle != null) {
            this.validateTimeCycle(validationResultCollector, timeCycle);
            ++definitionsCount;
        }
        if (definitionsCount != 1) {
            validationResultCollector.addError(0, "Must be exactly one type of timer: timeDuration, timeDate or timeCycle");
        }
    }

    private void validateTimeDate(TimeDate timeDate, ValidationResultCollector validationResultCollector) {
        try {
            TimeDateTimer.parse(timeDate.getTextContent());
        }
        catch (DateTimeParseException e) {
            validationResultCollector.addError(0, "Time date is invalid");
        }
    }

    private void validateTimeCycle(ValidationResultCollector validationResultCollector, TimeCycle timeCycle) {
        try {
            RepeatingInterval.parse(timeCycle.getTextContent());
        }
        catch (DateTimeParseException e) {
            validationResultCollector.addError(0, "Time cycle is invalid");
        }
    }

    private void validateTimeDuration(ValidationResultCollector validationResultCollector, TimeDuration timeDuration) {
        try {
            Interval.parse(timeDuration.getTextContent());
        }
        catch (DateTimeParseException e) {
            validationResultCollector.addError(0, "Time duration is invalid");
        }
    }
}

