/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.jsonpath;

import io.zeebe.msgpack.filter.MsgPackFilter;
import io.zeebe.msgpack.query.MsgPackFilterContext;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class JsonPathQuery {
    protected static final int MAX_DEPTH = 30;
    protected static final int MAX_FILTER_CONTEXT_LENGTH = 50;
    protected static final int NO_INVALID_POSITION = -1;
    protected MsgPackFilter[] filters;
    protected MsgPackFilterContext filterInstances = new MsgPackFilterContext(30, 50);
    protected UnsafeBuffer expressionBuffer = new UnsafeBuffer(0L, 0);
    protected DirectBuffer variableName = new UnsafeBuffer(0L, 0);
    protected int invalidPosition;
    protected String errorMessage;

    public JsonPathQuery(MsgPackFilter[] filters) {
        this.filters = filters;
    }

    public void wrap(DirectBuffer buffer, int offset, int length) {
        this.filterInstances.clear();
        this.invalidPosition = -1;
        this.expressionBuffer.wrap(buffer, offset, length);
    }

    public MsgPackFilterContext getFilterInstances() {
        return this.filterInstances;
    }

    public MsgPackFilter[] getFilters() {
        return this.filters;
    }

    public void invalidate(int position, String message) {
        this.invalidPosition = position;
        this.errorMessage = message;
    }

    public boolean isValid() {
        return this.invalidPosition == -1;
    }

    public int getInvalidPosition() {
        return this.invalidPosition;
    }

    public String getErrorReason() {
        return this.errorMessage;
    }

    public DirectBuffer getExpression() {
        return this.expressionBuffer;
    }

    public DirectBuffer getVariableName() {
        return this.variableName;
    }

    public void setVariableName(byte[] topLevelVariable) {
        this.variableName.wrap(topLevelVariable);
    }
}

