/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.mapping;

import io.zeebe.msgpack.mapping.Mapping;
import io.zeebe.msgpack.mapping.MappingException;
import io.zeebe.msgpack.mapping.MsgPackDiff;
import io.zeebe.msgpack.mapping.MsgPackDocumentExtractor;
import io.zeebe.msgpack.mapping.MsgPackDocumentIndexer;
import io.zeebe.msgpack.mapping.MsgPackDocumentTreeWriter;
import io.zeebe.msgpack.mapping.MsgPackTree;
import io.zeebe.msgpack.spec.MsgPackFormat;
import io.zeebe.msgpack.spec.MsgPackType;
import io.zeebe.util.EnsureUtil;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class MsgPackMergeTool {
    public static final int MAX_JSON_KEY_LEN = 256;
    public static final String EXCEPTION_MSG_RESULTING_DOCUMENT_IS_NOT_OF_TYPE_MAP = "Processing failed, since mapping will result in a non map object (json object).";
    public static final String EXCEPTION_MSG_MAPPING_NULL_NOR_EMPTY = "Mapping must be neither null nor empty!";
    private final MsgPackDocumentIndexer documentIndexer;
    private final MsgPackDocumentExtractor documentExtractor;
    private final MsgPackDocumentTreeWriter treeWriter;
    private final MsgPackTree currentTree = new MsgPackTree();
    private final UnsafeBuffer resultBuffer = new UnsafeBuffer(0L, 0);

    public MsgPackMergeTool(int initialDocumentSize) {
        this.documentIndexer = new MsgPackDocumentIndexer();
        this.documentExtractor = new MsgPackDocumentExtractor();
        this.treeWriter = new MsgPackDocumentTreeWriter(initialDocumentSize);
        this.reset();
    }

    public void reset() {
        this.currentTree.clear();
    }

    public void mergeDocument(DirectBuffer document, Mapping ... mappings) {
        this.mergeDocument(document, false, mappings);
    }

    public void mergeDocumentStrictly(DirectBuffer document, Mapping ... mappings) {
        this.mergeDocument(document, true, mappings);
    }

    private void mergeDocument(DirectBuffer document, boolean strictMode, Mapping ... mappings) {
        EnsureUtil.ensureNotNull((String)"document", (Object)document);
        if (mappings != null && mappings.length > 0) {
            MsgPackDiff diff = this.documentExtractor.extract(document, strictMode, mappings);
            diff.mergeInto(this.currentTree);
        } else {
            MsgPackTree diff = this.documentIndexer.index(document);
            diff.mergeInto(this.currentTree);
        }
    }

    public DirectBuffer writeResultToBuffer() {
        int resultLen = this.treeWriter.write(this.currentTree);
        this.resultBuffer.wrap((DirectBuffer)this.treeWriter.getResult(), 0, resultLen);
        this.ensureDocumentIsAMsgPackMap((DirectBuffer)this.resultBuffer, EXCEPTION_MSG_RESULTING_DOCUMENT_IS_NOT_OF_TYPE_MAP);
        return this.resultBuffer;
    }

    private void ensureDocumentIsAMsgPackMap(DirectBuffer document, String exceptionMsg) {
        byte b = document.getByte(0);
        MsgPackFormat format = MsgPackFormat.valueOf((byte)b);
        if (format.getType() != MsgPackType.MAP && format.getType() != MsgPackType.NIL) {
            throw new MappingException(exceptionMsg);
        }
    }
}

