/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.mapping;

import io.zeebe.msgpack.mapping.MsgPackDiff;
import io.zeebe.msgpack.mapping.MsgPackNodeType;
import io.zeebe.msgpack.mapping.MsgPackTreeNodeIdConstructor;
import io.zeebe.msgpack.spec.MsgPackWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.agrona.DirectBuffer;
import org.agrona.collections.Object2IntHashMap;

public class MsgPackTree
implements MsgPackDiff {
    protected final Map<String, MsgPackNodeType> nodeTypeMap;
    protected final Map<String, Set<String>> nodeChildsMap;
    protected final Map<String, Long> leafMap;
    protected final Object2IntHashMap<String> leafDocumentSources;
    private DirectBuffer[] documents = new DirectBuffer[0];

    public MsgPackTree() {
        this.nodeTypeMap = new HashMap<String, MsgPackNodeType>();
        this.nodeChildsMap = new HashMap<String, Set<String>>();
        this.leafMap = new HashMap<String, Long>();
        this.leafDocumentSources = new Object2IntHashMap(-1);
    }

    public int size() {
        return this.nodeTypeMap.size();
    }

    public void clear() {
        this.nodeChildsMap.clear();
        this.nodeTypeMap.clear();
        this.leafMap.clear();
        this.leafDocumentSources.clear();
        this.documents = new DirectBuffer[0];
    }

    public Set<String> getChildren(String nodeId) {
        return this.nodeChildsMap.get(nodeId);
    }

    public int addDocument(DirectBuffer document) {
        this.documents = Arrays.copyOf(this.documents, this.documents.length + 1);
        this.documents[this.documents.length - 1] = document;
        return this.documents.length - 1;
    }

    private void addContainerNode(String nodeId, MsgPackNodeType nodeType) {
        this.nodeTypeMap.put(nodeId, nodeType);
        this.nodeChildsMap.put(nodeId, new LinkedHashSet());
    }

    private void addChildToNode(String parentId, String childName) {
        if (!parentId.isEmpty()) {
            this.nodeChildsMap.get(parentId).add(childName);
        }
    }

    public boolean isValueNode(String nodeId) {
        return this.nodeTypeMap.get(nodeId) == MsgPackNodeType.VALUE;
    }

    public boolean isArrayNode(String nodeId) {
        return this.nodeTypeMap.get(nodeId) == MsgPackNodeType.ARRAY;
    }

    public boolean isMapNode(String nodeId) {
        return this.nodeTypeMap.get(nodeId) == MsgPackNodeType.MAP;
    }

    public void writeValueNode(MsgPackWriter writer, String nodeId) {
        long mapping = this.leafMap.get(nodeId);
        int position = (int)(mapping >> 32);
        int length = (int)mapping;
        int documentId = this.leafDocumentSources.getValue((Object)nodeId);
        DirectBuffer sourceDocument = this.documents[documentId];
        writer.writeRaw(sourceDocument, position, length);
    }

    @Override
    public void mergeInto(MsgPackTree other) {
        int newDocumentOffset = other.documents.length;
        for (DirectBuffer ourDocument : this.documents) {
            other.addDocument(ourDocument);
        }
        for (Map.Entry entry : this.nodeTypeMap.entrySet()) {
            String key = (String)entry.getKey();
            MsgPackNodeType nodeType = (MsgPackNodeType)((Object)entry.getValue());
            if (other.nodeTypeMap.get(key) != MsgPackNodeType.MAP || nodeType != MsgPackNodeType.ARRAY) {
                other.nodeTypeMap.put(key, nodeType);
            }
            other.leafMap.remove(key);
            int otherDocumentSource = this.leafDocumentSources.getValue((Object)key);
            if (otherDocumentSource < 0) continue;
            other.leafDocumentSources.put((Object)key, otherDocumentSource + newDocumentOffset);
        }
        other.leafMap.putAll(this.leafMap);
        for (Map.Entry entry : this.nodeChildsMap.entrySet()) {
            String key = (String)entry.getKey();
            if (key.equals("$")) {
                other.nodeChildsMap.computeIfAbsent(key, k -> new LinkedHashSet()).addAll((Collection)entry.getValue());
                continue;
            }
            other.nodeChildsMap.put(key, (Set<String>)entry.getValue());
        }
    }

    public void convertToArrayNode(String nodeId) {
        this.concertToContainer(nodeId, MsgPackNodeType.ARRAY);
    }

    public void convertToMapNode(String nodeId) {
        this.concertToContainer(nodeId, MsgPackNodeType.MAP);
    }

    private void concertToContainer(String nodeId, MsgPackNodeType containerType) {
        MsgPackNodeType priorType = this.nodeTypeMap.get(nodeId);
        if (priorType == MsgPackNodeType.VALUE) {
            this.leafMap.remove(nodeId);
            this.nodeChildsMap.put(nodeId, new LinkedHashSet());
        }
        this.nodeTypeMap.put(nodeId, containerType);
    }

    public String appendToArray(String parentId, String arrayNodeName, int documentId, int elementOffset, int elementLength) {
        String arrayNodeId = MsgPackTreeNodeIdConstructor.construct(parentId, arrayNodeName);
        if (this.hasNode(arrayNodeId)) {
            if (!this.isArrayNode(arrayNodeId)) {
                this.clearChildren(arrayNodeId);
                this.convertToArrayNode(arrayNodeId);
            }
        } else {
            this.addArrayNode(parentId, arrayNodeName);
        }
        int currentArrayElements = this.nodeChildsMap.get(arrayNodeId).size();
        String nodeName = Integer.toString(currentArrayElements);
        return this.addValueNode(arrayNodeId, nodeName, documentId, elementOffset, elementLength);
    }

    public String addArrayNode(String parentId, String arrayNodeName) {
        String nodeId = MsgPackTreeNodeIdConstructor.construct(parentId, arrayNodeName);
        this.addContainerNode(nodeId, MsgPackNodeType.ARRAY);
        this.addChildToNode(parentId, arrayNodeName);
        return nodeId;
    }

    public String addValueNode(String parentId, String nodeName, int documentId, int valueOffset, int valueLength) {
        String nodeId = MsgPackTreeNodeIdConstructor.construct(parentId, nodeName);
        this.leafMap.put(nodeId, (long)valueOffset << 32 | (long)valueLength);
        this.leafDocumentSources.put((Object)nodeId, documentId);
        this.nodeTypeMap.put(nodeId, MsgPackNodeType.VALUE);
        this.addChildToNode(parentId, nodeName);
        return nodeId;
    }

    public String addMapNode(String parentId, String nodeName) {
        String nodeId = MsgPackTreeNodeIdConstructor.construct(parentId, nodeName);
        this.addContainerNode(nodeId, MsgPackNodeType.MAP);
        this.addChildToNode(parentId, nodeName);
        return nodeId;
    }

    private boolean isContainerNode(String nodeId) {
        MsgPackNodeType nodeType = this.nodeTypeMap.get(nodeId);
        return nodeType == MsgPackNodeType.ARRAY || nodeType == MsgPackNodeType.MAP;
    }

    public boolean hasNode(String id) {
        return this.nodeTypeMap.containsKey(id);
    }

    public void clearChildren(String nodeId) {
        if (this.isContainerNode(nodeId)) {
            this.nodeChildsMap.get(nodeId).clear();
        }
    }
}

