/*
 * Decompiled with CFR 0.152.
 */
package io.zeebe.msgpack.query;

import io.zeebe.msgpack.filter.MsgPackFilter;
import io.zeebe.msgpack.query.MsgPackFilterContext;
import io.zeebe.msgpack.query.MsgPackTokenVisitor;
import io.zeebe.msgpack.query.MsgPackTraversalContext;
import io.zeebe.msgpack.spec.MsgPackCodes;
import io.zeebe.msgpack.spec.MsgPackToken;
import io.zeebe.msgpack.spec.MsgPackType;
import io.zeebe.util.allocation.BufferAllocator;
import io.zeebe.util.allocation.HeapBufferAllocator;
import io.zeebe.util.collection.CompactList;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class MsgPackQueryExecutor
implements MsgPackTokenVisitor {
    protected static final int MAX_TRAVERSAL_DEPTH = 30;
    protected static final int MAX_RESULTS = 1000;
    protected static final int RESULT_SIZE = 8;
    protected static final int RESULT_POSITION_OFFSET = 0;
    protected static final int RESULT_LENGTH_OFFSET = 4;
    protected MsgPackFilter[] filters;
    protected MsgPackFilterContext filterInstances;
    protected int numFilterInstances;
    protected CompactList matchingPositions;
    protected UnsafeBuffer currentResultView = new UnsafeBuffer(0L, 0);
    protected UnsafeBuffer resultWriteBuffer = new UnsafeBuffer(new byte[8]);
    protected int matchingContainer = -1;
    protected int matchingContainerStartPosition;
    protected MsgPackTraversalContext context = new MsgPackTraversalContext(30, 4);

    public MsgPackQueryExecutor() {
        this.matchingPositions = new CompactList(8, 1000, (BufferAllocator)new HeapBufferAllocator());
    }

    public void init(MsgPackFilter[] filters, MsgPackFilterContext filterInstances) {
        this.filters = filters;
        this.filterInstances = filterInstances;
        this.numFilterInstances = filterInstances.size();
        this.matchingPositions.clear();
    }

    @Override
    public void visitElement(int position, MsgPackToken currentValue) {
        MsgPackType currentValueType;
        int currentFilter = 0;
        if (this.context.hasElements()) {
            this.context.moveToLastElement();
            this.context.currentElement(this.context.currentElement() + 1);
            currentFilter = this.context.applyingFilter();
        }
        boolean filterMatch = false;
        if (currentFilter >= 0) {
            this.filterInstances.moveTo(currentFilter);
            MsgPackFilter filter = this.filters[this.filterInstances.filterId()];
            filterMatch = filter.matches(this.context, (DirectBuffer)this.filterInstances.dynamicContext(), currentValue);
        }
        if (MsgPackType.ARRAY == (currentValueType = currentValue.getType()) || MsgPackType.MAP == currentValueType) {
            this.context.appendElement();
            this.context.currentElement(-1);
            this.context.numElements(currentValueType == MsgPackType.MAP ? currentValue.getSize() * 2 : currentValue.getSize());
            this.context.applyingFilter(-1);
            this.context.setIsMap(MsgPackType.MAP == currentValueType);
        }
        if (filterMatch) {
            if (this.isLastFilter(currentFilter)) {
                if (currentValue.getType().isScalar()) {
                    this.addResult(position, currentValue.getTotalLength());
                } else {
                    this.matchingContainer = this.context.size() - 1;
                    this.matchingContainerStartPosition = position;
                }
            } else {
                this.context.applyingFilter(currentFilter + 1);
            }
        }
        while (this.context.hasElements() && this.context.currentElement() + 1 >= this.context.numElements()) {
            if (this.matchingContainer == this.context.size() - 1) {
                this.addResult(this.matchingContainerStartPosition, position + currentValue.getTotalLength() - this.matchingContainerStartPosition);
                this.matchingContainer = -1;
            }
            this.context.removeLastElement();
        }
    }

    protected boolean isLastFilter(int filterIndex) {
        return filterIndex + 1 == this.numFilterInstances;
    }

    public int numResults() {
        return this.matchingPositions.size();
    }

    public void moveToResult(int index) {
        this.matchingPositions.wrap(index, (MutableDirectBuffer)this.currentResultView);
    }

    public int currentResultPosition() {
        return this.currentResultView.getInt(0);
    }

    public int currentResultLength() {
        return this.currentResultView.getInt(4);
    }

    public boolean isCurrentResultAMap(DirectBuffer document) {
        byte headerByte = document.getByte(this.currentResultPosition());
        return MsgPackCodes.isMap((byte)headerByte);
    }

    protected void addResult(int position, int length) {
        this.resultWriteBuffer.putInt(0, position);
        this.resultWriteBuffer.putInt(4, length);
        this.matchingPositions.add((DirectBuffer)this.resultWriteBuffer);
    }
}

